//
//  VirtualDelegate.m
//  VirtualDelegate
//

#import "VirtualDelegate.h"

@implementation VirtualDelegate

- (NSMethodSignature*)methodSignatureForSelector:(SEL)sel
{
    id sig = [self.realObject methodSignatureForSelector: sel];
    if(sig)
        return sig;
    sig = [self.defaultObject methodSignatureForSelector: sel];
    if (sig)
        return sig;
    return [NSMethodSignature signatureWithObjCTypes: "@^v^c"];
}

- (void)forwardInvocation:(NSInvocation *)invocation
{
    SEL selector = invocation.selector;

    id realObject = self.realObject;
    if([realObject respondsToSelector: selector])
    {
        [invocation invokeWithTarget: realObject];
        return;
    }
    
    id defaultObject = self.defaultObject;
    if([defaultObject respondsToSelector: selector])
    {
        [invocation invokeWithTarget: defaultObject];
        return;
    }
}
@end
