//
//  ECLayer.h
//  SceneRenderProto
//
//  Created by 二鏡 on 11/11/13.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ECImageRef.h"
#import "ECLayer.h"
#import "ECQCCompositionItem.h"

extern NSString *ECPasteboardTypeRegularLayer;

@interface ECRegularLayer : ECLayer <NSPasteboardReading, NSPasteboardWriting, NSCoding,NSCopying,QCLayer>
{
    CGLayerRef cache; // cache for composition
    CTTypesetterRef typesetter;
    QCRenderer *effector;
    
    // image
    ECImageRef *imageRef;
    
    // text
    CGRect textFrame;
    NSString *string;
    NSFont *font;
    CGColorRef fontColor;
    CGFloat lineSpacing;
    NSTextAlignment alignment;
    BOOL isVertical;
    
    // version 1.1
    CGColorRef textStrokeColor;
    BOOL useTextStroke;
    BOOL useTextShadow;
    
    // ページの全体時間を計算する時に文字長を判断対象とするか
    BOOL countTextWait; 
    
    BOOL useTextWait;
    // waitモードで動画生成をする時に一文字辺りの待ち時間
    // renering時間が足りない場合は途中で放棄される
    // renderInContext:では無視される
    NSUInteger textWait; // msec
    
    // post effect
    ECQCCompositionItem *postEffect; 
    // ここではImage Filterを扱う
    // Image FilterはInput Image->Output Imageを行うcompositionである
}
- (id)initWithImage:(ECImageRef*)aImage
               size:(CGSize)aSize;
- (id)initWithPropertyList:(NSDictionary*)plist
                packageURL:(NSURL*)aURL;
+ (NSString*)type;
- (NSURL*)auxResourceURL;
- (id)propertyListWithAuxResourceName:(NSString*)filename;

@property (nonatomic,readwrite,retain) ECImageRef* image;
@property (nonatomic,readwrite,copy) NSString *string;
@property (nonatomic,readwrite,retain) NSFont *font;
@property (nonatomic,readwrite,copy) NSColor *fontColor;
@property (readwrite) BOOL verticalText;
@property (nonatomic,readwrite) CGFloat lineSpacing;
@property (nonatomic,readwrite) CGRect textFrame;
@property (readwrite) BOOL countTextWait;
@property (readwrite) BOOL useTextWait;
@property (readwrite) NSUInteger textWait;
@property (nonatomic,readwrite) NSTextAlignment alignment;

// version 1.1
@property (readwrite,retain) NSColor *textStrokeColor;
@property (readwrite) BOOL useTextStroke;
@property (readwrite) BOOL useTextShadow;

// view用のサービスメソッド
- (void)drawTextFrame;

@end
