//
//  ECRender.h
//  Etokicho
//
//  Created by 二鏡 on 11/11/19.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <QTKit/QTKit.h>

@protocol ECRendererDelegate
- (void)rendererWillRenderSegment:(id)segment 
                          atIndex:(NSUInteger)i
                         inSource:(NSArray*)source;
- (void)rendererDidRenderSegment:(id)segment 
                         atIndex:(NSUInteger)i
                        inSource:(NSArray*)source;
- (BOOL)rendererShouldStopRendering;
@end

// レンダリングアイテム
@protocol ECRendererSegment
@property (readwrite) BOOL lightPreview;
- (void)insertSegment:(QTMovie*)aMovie
            frameRate:(NSUInteger)fps
                 size:(NSSize)aSize;
- (void)cleanup;
@end

@interface ECRenderer : NSObject
{
    QTMovie *movie;
    
    // render source
    NSArray *source;
    NSRange renderRange; // オリジナルのrange
    NSUInteger fps;
    NSSize size;
    
    // simple callback
    id target;
    SEL completionHandler;   // 1-argument messge
    
    BOOL shouldContinue;
    id <ECRendererDelegate> delegate;
}
@property (readwrite,assign) id <ECRendererDelegate> delegate;

@property (readonly) QTMovie *movie;
@property (readonly) NSRange renderRange;
@property (readwrite) BOOL shouldContinue;
@property (readwrite) NSUInteger fps;
@property (readwrite) NSSize size;

// プレビュー製作用に部分処理が出来る。NSZeroRangeを渡すと完全処理する
- (void)setRenderSource:(NSArray*)segments
                  range:(NSRange)range;
// sourceにlight previewを設定 setRenderSourceの後に使うこと
- (void)setLightPreview:(BOOL)flag; 
- (void)clearRenderSource;

// スレッド切り離しに成功したらYES。
// callbackはmovieオブジェクトを受け取る1引数
// 強制停止した時はnil
- (BOOL)detachRenderThreadWithCompletionHandler:(SEL)aSel
                                         target:(id)obj
                                          error:(NSError**)error;

- (void)invalidate;
- (BOOL)detachExportThreadWithCompletionHandler:(SEL)aSel
                                         target:(id)obj
                                            URL:(NSURL*)aURL;
@end