//
//  ECQCCompositionItem.h
//  Etokicho
//
//  Created by 二鏡 on 11/11/27.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Quartz/Quartz.h>

@interface ECQCCompositionItem : NSObject <NSCopying, NSCoding>
@property (readwrite,copy) NSString *identifier;
@property (readwrite,copy) NSDictionary *parameters;

+ (id)itemWithRenderer:(QCRenderer*)renderer;
- (QCComposition*)loadComposition;
- (void)apply:(id <QCCompositionRenderer>)renderer;
@end


@protocol QCLayer
@property (readwrite,copy) ECQCCompositionItem *compositionItem;
@optional
- (QCComposition*)loadEmbeddedComposition; 
// repositoryからロードできないものを使うか？
// 要はムービー用だが未使用に終りそうだ...
@required
- (BOOL)isUseEmbeddedComposition;
- (QCRenderer*)attachRenderer:(QCComposition*)composition;
- (void)forceEffectParameters;
- (ECQCCompositionItem*)currentRendererParameters;
@end
