#
# Copyright (c) 2023 supercell
#
# SPDX-License-Identifier: BSD-3-Clause
#

module Luce
  # Parses atx-style headers: `## Header ##`.
  class HeaderSyntax < BlockSyntax
    def pattern : Regex
      Luce.header_pattern
    end

    def parse(parser : BlockParser) : Node
      match = pattern.match(parser.current)
      parser.advance
      level = match.not_nil![1].size
      contents = UnparsedContent.new(match.not_nil![2].strip)
      Element.new("h#{level}", [contents] of Node)
    end
  end
end
