window.addEventListener('load',function(){
	var board=new reversi.Board(8,8);
	var visualizer=new reversi.Visualizer(board);
	visualizer.displayScore=0;
	document.body.appendChild(visualizer.dom);
	board.putDataByCursor(new reversi.Cursor(3,3),2,true);
	board.putDataByCursor(new reversi.Cursor(4,4),2,true);
	board.putDataByCursor(new reversi.Cursor(3,4),1,true);
	board.putDataByCursor(new reversi.Cursor(4,3),1,true);
	
	var controller=new reversi.Controller();
	document.body.appendChild(controller.dom);
	
	var player_B=new reversi.player.NSeer(3);
	var player_W=new reversi.player.Manual(visualizer);
	
	var playerDomBox=document.createElement('div');
	playerDomBox.style.margin='5px';
	playerDomBox.appendChild(player_B.dom);
	playerDomBox.appendChild(player_W.dom);
	document.body.appendChild(playerDomBox);
	
	//Google Analyticsへ送信
	controller.addEvent("gameset",function(){
		if(!ga||(player_W.name!="manual"&&player_B.name!="manual")||location.search.indexOf("no-analytics")>-1){
			return false;
		}
		var wn,s=board.countPlayerScore();
		if(s[1]>s[2]){
			wn=player_B.name;
		}else{
			wn=player_W.name;
		}
		ga('send', 'event', 'game', 'win', player_B.name+" vs "+player_W.name , s[1]);
		ga('send', 'event', 'game', 'fin', wn);
	});
	
	controller.start(board,[
		player_B,player_W
	]);
	
	var vis_B=new reversi.Visualizer(board);
	vis_B.displayScore=1;
	vis_B.dom.style.width='200px';
	vis_B.dom.style.height='200px';
	vis_B.dom.style.float='left';
	var vis_W=new reversi.Visualizer(board);
	vis_W.displayScore=2;
	vis_W.dom.style.width='200px';
	vis_W.dom.style.height='200px';
	vis_W.dom.style.float='left';
	var visBW=document.createElement('div');
	document.body.appendChild(visBW);
	visBW.appendChild(vis_B.dom);
	visBW.appendChild(vis_W.dom);
	vis_B.update();
	vis_W.update();
});