/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;
import static java.lang.Math.abs;

/**
 *
 * @author mtomono
 * @param <T>
 */
public class ErroredOrder<T extends Comparable<T>> extends EqCenteredOrder<T> {
    double eps;
    
    public ErroredOrder(double eps) {
        this.eps = eps;
    }
    
    @Override
    public boolean eq(T c1, T c2) {
        if (c1 instanceof Double || c2 instanceof Double) {
            return abs(((Double)c1) - ((Double)c2)) < eps;
        } else {
            return c1.compareTo(c2) == 0;
        }
    }

    @Override public boolean eq(double c1, double c2) { return abs(c1 - c2) < eps; }
    @Override public boolean eq(long   c1, long   c2) { return abs(c1 - c2) < eps; }
    @Override public boolean eq(int    c1, int    c2) { return abs(c1 - c2) < eps; }
}
