/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package debug;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.function.Function;

/**
 *
 * @author mtomono
 */
public class SimpleTrace implements Trace {
    static String defaultIndentUnit = "  ";
    static PrintWriter defaultOutput = new PrintWriter(System.out, true);
    String indent;
    String indentUnit;
    PrintWriter output;
    
    public SimpleTrace() {
        this(defaultOutput, defaultIndentUnit);
    }
    
    public SimpleTrace(PrintWriter output, String indentUnit) {
        this.indent = "";
        this.output = output;
        this.indentUnit = indentUnit;
    }
    
    public boolean cr() {
        output.flush();
        return true;
    }
    
    private void indentUp() {
        indent += indentUnit;
    }
    private void indentDown() {
        indent = indent.substring(indentUnit.length());
    }
    private String indent() {
        return indent;
    }

    @Override
    public boolean l(Function<String, String>... log) {
        output.println(indent + Arrays.asList(log).stream().map(l->l.apply("")).reduce("", (a, b)->a+b));
        return true;
    }

    @Override
    public boolean u(Function<String, String>... log) {
        indentUp();
        l(log);
        return true;
    }

    @Override
    public boolean d(Function<String, String>... log) {
        l(log);
        indentDown();
        return true;
    }
        
}
