/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package debug;
import java.util.*;
/**
 *
 * @author mtomono
 */
public class Format {
    public static String concat(Iterator iter, String delimiter, String parenthesis) {
        String retval = "";
        while (iter.hasNext()) {
            retval += iter.next();
            if (iter.hasNext()) {
                retval += delimiter;
            }
        }
        return parenthesis(retval, parenthesis);
    }

    public static String concat(Iterable list, String delimiter, String parenthesis) {
        return concat(list.iterator(), delimiter, parenthesis);
    }
    
    public static String concat(String delimiter, String parenthesis, Object... target) {
        return concat(Arrays.asList(target), delimiter, parenthesis);
    }
    
    public static <T> String between(T from, T to, String parenthesis) {
        return parenthesis("" + from + "<->" + to, parenthesis);
    }

    public static <T> String below(T to, String parenthesis) {
        return parenthesis("->" + to, parenthesis);
    }

    public static <T> String above(T from, String parenthesis) {
        return parenthesis("" + from + "<-", parenthesis);
    }

    public static String parenthesis(String string, String parenthesis) {
        if (parenthesis == null || parenthesis.length() != 2) {
            return string;
        }
        String retval = "";
        retval += parenthesis.charAt(0);
        retval += string;
        retval += parenthesis.charAt(1);
        return retval;
    }

    public static String function(String name, String value) {
        return name + parenthesis(value, "()");
    }
    
    public static String collection(Collection c) {
        return concat(c, ", ", "[]");
    }
}
