/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package collection;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

/**
 *
 * @author mtomono
 */
public class DualList<T, S> extends AbstractList<T> {
    Function<T, S> translator;
    Optional<DualList<S, T>> dual;
    List<T> body;
    
    public DualList(List<T> body, Function<T, S> translator) {
        this.body = body;
        this.translator = translator;
        this.dual = Optional.empty();
    }
    
    public DualList(Function<T, S> translator) {
        this(new ArrayList<>(), translator);
    }
    
    public void setDual(DualList<S, T> dual) {
        this.dual = Optional.of(dual);
    }
    
    @Override
    public T get(int index) {
        return body.get(index);
    }

    @Override
    public int size() {
        return body.size();
    }
    
    @Override
    public void add(int i, T t) {
        assert dual.isPresent();
        dual.get().add(i, translator.apply(t));
        body.add(i, t);
    }
    
    public void add(int i, T t, S s) {
        assert dual.isPresent();
        dual.get().add(i, s);
        body.add(i, t);
    }
    
    public void add(T t, S s) {
        add(size() - 1, t, s);
    }
    
    public void addAll(int i, Collection<T> t, Collection<S> s) {
        assert dual.isPresent();
        dual.get().addAll(i, s);
        body.addAll(i, t);
    }
    
    public void addAll(Collection<T> t, Collection<S> s) {
        addAll(size() - 1, t, s);
    }
    
    @Override
    public T set(int i, T t) {
        assert dual.isPresent();
        dual.get().set(i, translator.apply(t));
        return body.set(i, t);
    }
    
    public void set(int i, T t, S s) {
        assert dual.isPresent();
        dual.get().set(i, s);
        body.set(i, t);
    }
    
    @Override
    public T remove(int i) {
        assert dual.isPresent();
        dual.get().remove(i);
        return body.remove(i);
    }
}
