/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package view;

import java.util.AbstractList;
import java.util.List;
import java.util.Optional;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import static java.util.stream.Collectors.toList;

/**
 *
 * @author mtomono
 * @param <E>
 */
public class View<E> extends AbstractList<Optional<E>> {
    int index;
    List<E> target;
    IntUnaryOperator at;
    IntSupplier start;
    IntSupplier end;
    int size;
    
    public static <E> View<E> pre(List<E> target, int buflen) {
        return new View(target, buflen).offset().reverse();
    }
    
    public static <E> View<E> fore(List<E> target, int buflen) {
        return new View(target, buflen);
    }
    
    public View(List<E> target, int size) {
        this.target = target;
        this.index = 0;
        this.at = (int n) -> n + this.index;
        this.start = ()->0;
        this.end = this.target::size;
        this.size = size;
    }
    
    public boolean t(int index, Predicate<E> t) {
        return !get(index).isPresent() || t.test(get(index).get());
    }
    
    public E g(int index) {
        return get(index).get();
    }
    
    public IntSupplier start() {
        return start;
    }
    
    public IntSupplier end() {
        return end;
    }
    
    public View<E> offset() {
        return offset(size-1);
    }
    
    public View<E> offset(int offset) {
        return wrapAt(n->n+offset);
    }
    
    public View<E> reverse() {
        return wrapAt(n->-n);
    }
    
    public View<E> wrapAt(IntUnaryOperator mapper) {
        at = mapper.andThen(at);
        return this;
    }
    
    public boolean has(int index) {
        return start.getAsInt() <= at.applyAsInt(index) && at.applyAsInt(index) < end.getAsInt();
    }
    
    public int at(int index) {
        return at.applyAsInt(index);
    }
    
    public View<E> index(int index) {
        this.index = index;
        return this;
    }
    
    public List<E> values() {
        return this.stream().map(v->v.get()).collect(toList());
    }
    
    @Override
    public Optional<E> get(int index) {
        if (has(index))
            return Optional.ofNullable(target.get(at(index)));
        return Optional.empty();
    }
    
    @Override
    public int size() {
        return size;
    }    
}
