/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package iterator;

import java.util.ListIterator;
import java.util.function.Predicate;

/**
 * an iterator which stops when the terminator returns true.
 * @author mtomono
 */
public class UntilIterator<T> extends AbstractIterator<T> {
    Predicate<? super T> terminator;
    ListIterator<T> body;
    
    public UntilIterator(ListIterator<T> body, Predicate<? super T> terminator) {
        this.body = body;
        this.terminator = terminator;
    }
    
    @Override
    protected void findNext() {
        if (!body.hasNext())
            return;
        T current = body.next();
        if (!terminator.test(current)) {
            nextFound(current);
        } else {
            body.previous();
        }
    }
}
