/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package grammar;

import collection.c;
import context.IContext;
import java.util.List;
import debug.Format;

/**
 *
 * @author mtomono
 * @param <T>
 */
public class Or<T> extends Grammar<T> {
    List<Grammar<T>> body;
    public Or(Grammar<T>... body) {
        this.body = c.a2l(body);
    }
    
    @Override
    public int minLength() {
        return body.stream().mapToInt(n->n.minLength()).min().orElse(0);
    }
    
    @Override
    public boolean match(IContext<T> target) {
        return this.body.stream().anyMatch(g->g.parse(target));
    }

    @Override
    public String bodyToString() {
        return Format.concat(this.body, "||", "()");
    }
}