/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package geom;

import static geom.Compass.clockwise4dirs;
import static geom.Compass.counterclockwise4dirs;

/**
 *
 * @author mtomono
 */
abstract public class Dir {
    Dir opposite;
    final static public Dir left = new Left();
    final static public Dir right = new Right();

    static {
        left.opposite = right;
        right.opposite = left;
    }
    static public Dir ccw = left;
    static public Dir cw = right;

    abstract public boolean gt(double smaller, double greater);
    abstract public double fore(double amount);
    abstract public Iterable<Integer> dirs(int start);

    public Dir opposite() {
        return opposite;
    }

    static class Left extends Dir {

        @Override
        public boolean gt(double smaller, double greater) {
            return smaller < greater;
        }

        @Override
        public double fore(double amount) {
            return amount;
        }

        @Override
        public Iterable<Integer> dirs(int start) {
            return counterclockwise4dirs(start);
        }
    }

    static class Right extends Dir {

        @Override
        public boolean gt(double smaller, double greater) {
            return smaller > greater;
        }

        @Override
        public double fore(double amount) {
            return -amount;
        }

        @Override
        public Iterable<Integer> dirs(int start) {
            return clockwise4dirs(start);
        }
    }
}
