package orderedSet;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author mtomono
 * @param <T>
 */
abstract public class Order<T extends Comparable<T>> {
    abstract public boolean eq(T c1, T c2);
    abstract public boolean lt(T c1, T c2);
    
    public boolean ne(T c1, T c2) {
        return !eq(c1, c2);
    }
    
    public boolean gt(T c1, T c2) {
        return lt(c2, c1);
    }

    public boolean ge(T c1, T c2) {
        return !lt(c1, c2);
    }

    public boolean le(T c1, T c2) {
        return !gt(c1, c2);
    }
    
    public boolean alwaysTrue(T c1, T c2) {
        return true;
    }
    
    public boolean alwaysFalse(T c1, T c2) {
        return !alwaysTrue(c1, c2);
    }
}
