/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import java.util.ArrayList;
import java.util.ListIterator;

/**
 *
 * @author mtomono
 */
public class Accumulation<T extends Comparable<T>> extends ArrayList<RangeSet<T>> {
    
    private RangeSet<T> overlay(ListIterator<RangeSet<T>> iter, RangeSet<T> added) {
        RangeSet<T> body = iter.next();
        RangeSet<T> carriedOver = body.intersect(added);
        iter.set(body.union(added));
        return carriedOver;
    }
    
    private RangeSet<T> peel(ListIterator<RangeSet<T>> iter, RangeSet<T> removed) {
        RangeSet<T> body = iter.previous();
        RangeSet<T> borrowedUnder = body.mask(removed);
        iter.set(body.maskedBy(removed));
        return borrowedUnder;
    }

    public void overlay(RangeSet<T> e) {
        ListIterator<RangeSet<T>> iter = listIterator();
        RangeSet<T> carriedOver = e;
        while (iter.hasNext())
            carriedOver = overlay(iter, carriedOver);
        if (!carriedOver.isEmpty())
            add(carriedOver);
    }
    
    public RangeSet<T> peel(RangeSet<T> e) {
        ListIterator<RangeSet<T>> iter = listIterator(size());
        RangeSet<T> borrowedUnder = e;
        while (iter.hasPrevious()) 
            borrowedUnder = peel(iter, borrowedUnder);
        if (get(size() - 1).isEmpty())
            remove(size() - 1);
        return borrowedUnder;
    }
}
