/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package grammar.action;

import context.IContext;
import java.util.function.Function;
import grammar.Grammar;
import parser.ParseResult;

/**
 * This action completes the ParseResult of this branch (set range in ParseResult). 
 * Transformation can be specified by Function
 * @author mtomono
 */
public class BuildTree extends Branch {
    Function body;
    
    public BuildTree() {
        this(Function.identity());
    }
    
    public BuildTree(Function body) {
        this.body = body;
    }

    @Override
    public void match(IContext<?> context, int start, int end, Grammar origin) {
        ParseResult retval = context.stack().pop();
        retval.setRange(start, end);
        if (!context.stack().isEmpty())
            context.stack().peek().add(body.apply(retval));
    }
    
    @Override
    public String toString() {
        return "@+";
    }
}
