/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package orderedSet;

import iterator.SingleBufferedListIterator;
import java.util.Iterator;
import java.util.ListIterator;

/**
 *
 * @author mtomono
 * @param <E>
 */
public class AssertOrderListIterator<E> implements ListIterator<E> {
    ListIterator<E> body;
    
    public boolean inOrder(E pre, E now) {
        if (pre instanceof Range)
            return ((Range)pre).isLowerThan((Range)now);
        if (pre instanceof Comparable)
            return ((Comparable)pre).compareTo((Comparable)now) < 0;
        return false;
    }
    
    protected AssertOrderListIterator(ListIterator<E> body) {
        this.body = body;
    }
    
    public AssertOrderListIterator(Iterator<E> body) {
        this.body = new SingleBufferedListIterator<>(body);
    }
    
    public boolean require() {
        if (!body.hasPrevious() || !body.hasNext())
            return true;
        E pre = body.previous();
        body.next();
        E now = body.next();
        body.previous();
        return inOrder(pre, now);
    }
    
    @Override
    public E next() {
        E retval = body.next();
        assert require();
        return retval;
    }
    
    @Override
    public boolean hasNext() {
        return body.hasNext();
    }

    @Override
    public void remove() {
        body.remove();
    }

    @Override
    public E previous() {
        return body.previous();
    }

    @Override
    public boolean hasPrevious() {
        return body.hasPrevious();
    }

    @Override
    public int nextIndex() {
        return body.nextIndex();
    }

    @Override
    public int previousIndex() {
        return body.previousIndex();
    }

    @Override
    public void set(E e) {
        body.set(e);
    }

    @Override
    public void add(E e) {
        body.add(e);
    }
}
