/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: kernellogcontrol.cpp,v 1.1 2008/06/17 00:04:55 suikan Exp $
 */

// KernelLogControl.cpp : CKernelLogControl ̃Cve[V

#include "stdafx.h"
#include "Watcher.h"
#include "KernelLogControl.h"

/////////////////////////////////////////////////////////////////////////////
// CKernelLogControl


STDMETHODIMP CKernelLogControl::Open()
{
	// TODO: ̈ʒuɃCvgp̃R[hǉĂ
	if(!FAILED(manager.CoCreateInstance(CLSID_KernelLog)) && !FAILED(manager.Advise((_IKernelLogEvents *)this,__uuidof(_IKernelLogEvents),&cookie)))
		return S_OK;
	if(!!manager)
		manager.Release();
	return E_FAIL;
}

STDMETHODIMP CKernelLogControl::Close()
{
	// TODO: ̈ʒuɃCvgp̃R[hǉĂ
	if(!manager)
		return E_FAIL;

	AtlUnadvise(manager, __uuidof(_IKernelLogEvents),cookie);
	manager.Release();
	cookie = 0;
	return S_OK;
}

STDMETHODIMP CKernelLogControl::get_Type(long *pVal)
{
	// TODO: ̈ʒuɃCvgp̃R[hǉĂ
	if(log != NULL)
	{
		*pVal = (long)log->header.logtype;
	}else
		*pVal = 0;

	return S_OK;
}

STDMETHODIMP CKernelLogControl::get_Logtim(long *pVal)
{
	// TODO: ̈ʒuɃCvgp̃R[hǉĂ
	if(log != NULL)
	{
		*pVal = (long)log->header.logtim;
	}else
		*pVal = 0;
	return S_OK;
}

STDMETHODIMP CKernelLogControl::get_isValid(BOOL *pVal)
{
	// TODO: ̈ʒuɃCvgp̃R[hǉĂ
	if(log != NULL)
		*pVal = TRUE;
	else
		*pVal = FALSE;
	return S_OK;
}

STDMETHODIMP CKernelLogControl::get_Param(long index, long *pVal)
{
	// TODO: ̈ʒuɃCvgp̃R[hǉĂ
	*pVal = *((long *)&log->body + index);

	return S_OK;
}
