/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: kernel.cpp,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

#include "stdafx.h"
#include "devicemanager.h"
#include "kernel.h"

/////////////////////////////////////////////////////////////////////////////
// CKernel

CKernel::CKernel()
{
	Valid = _Module.AttachKernel(this);
}

CKernel::~CKernel()
{
	_Module.DetachKernel(this);
}

STDMETHODIMP CKernel::IsValid(BOOL *valid)
{
	*valid = Valid ? TRUE : FALSE;
	return S_OK;
}

STDMETHODIMP CKernel::Read(unsigned long address, unsigned long sz, unsigned char data[])
{
	if(Valid && _Module.Read(this,address,sz,data))
		return S_OK;
	return E_FAIL;
}

STDMETHODIMP CKernel::Write(unsigned long address, unsigned long sz, unsigned char data[])
{
	if(Valid!=FALSE && _Module.Write(this,address,sz,data))
		return S_OK;
	return E_FAIL;
}

STDMETHODIMP CKernel::OnLogEvent(long sz, unsigned char data[])
{
	if(Valid!=FALSE && _Module.OnLogEvent(this,sz,data))
		return S_OK;
	return E_FAIL;
}
