/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: device.cpp,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

#include "stdafx.h"
#include "devicemanager.h"
#include "device.h"

/////////////////////////////////////////////////////////////////////////////
// CDevice


CDevice::CDevice()
{
	DevID = _Module.AddDevice(this);
}

CDevice::~CDevice()
{
	if(DevID != 0)
		_Module.DeleteDevice(this);
}

STDMETHODIMP CDevice::IsValid(BOOL * valid)
{
	*valid = DevID != 0 ? TRUE : FALSE;
	return S_OK;
}

STDMETHODIMP CDevice::SetDeviceName(BSTR devname)
{
	DeviceName = devname;
	return S_OK;
}

STDMETHODIMP CDevice::Map(unsigned long address, unsigned long size)
{
	if( DevID == 0 )
		return E_HANDLE;
	if(_Module.Map(this,Range(address,size)) == false)
		return E_INVALIDARG;
	return S_OK;
}

STDMETHODIMP CDevice::Unmap(unsigned long address)
{
	if( DevID == 0 )
		return E_HANDLE;
	if(_Module.Unmap(this, address) == false)
		return E_INVALIDARG;
	return S_OK;
}

STDMETHODIMP CDevice::RaiseInterrupt(unsigned long inhno)
{
	if(DevID == 0)
		return E_HANDLE;
	if(_Module.Kernel == 0)
		return E_ACCESSDENIED;
	if(_Module.RaiseInterrupt(inhno) == false)
		return E_INVALIDARG;
	return S_OK;
}
