/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: sample1.h,v 1.1 2008/06/17 00:04:45 suikan Exp $
 */

/*
 *  TvvO(1)̃wb_t@C
 */

#include "cpu_defs.h"
#include "sys_defs.h"

/*
 *  e^XN̗Dx̒`
 */

#define MAIN_PRIORITY	5		/* C^XN̗Dx */
					/* HIGH_PRIORITY 荂邱 */

#define HIGH_PRIORITY	9		/* Ɏs^XN̗Dx */
#define MID_PRIORITY	10
#define LOW_PRIORITY	11

/*
 *  ^[Qbgˑ̒`iCPUOnh̋N@Ȃǁj
 */

#ifdef M68K

#define CPUEXC1		5		/* [ZO */
#define RAISE_CPU_EXCEPTION	syslog(LOG_NOTICE, "zerodiv = %d", 10 / 0)

#elif defined(SH3)

#define CPUEXC1		224		/* [hG[O */
#define RAISE_CPU_EXCEPTION	(*((volatile int *) 0xFFFFFEC1))

#elif defined(SH1)

#define CPUEXC1		9		/* CPUAhXG[O */
#define RAISE_CPU_EXCEPTION	(*((volatile int *) 0xFFFFFEC1))
#ifdef TOKIWA_SH1
#define	STACK_SIZE	512		/* ^XÑX^bNTCY */
#endif /* TOKIWA_SH1 */

#elif defined(ARM7TDMI)

#define CPUEXC1		4		/* [hG[O */
#define RAISE_CPU_EXCEPTION	(*((volatile int *) 0xFFFFFEC1))

#elif defined(V850)

#elif defined(H8)

#undef CPUEXC1				/* CPUOnhT|[gȂ */

#elif defined(H8S)

#undef CPUEXC1				/* CPUOnhT|[gȂ */
#define LOOP_REF	4000L		/* xvp̃[v */

#elif defined(MICROBLAZE)

#undef CPUEXC1				/* CPUOnhT|[gȂ */
#define STACK_SIZE	2048		/* ^XÑX^bNTCY */

#elif defined(I386)

#define CPUEXC1		0		/* [ZO */
#define RAISE_CPU_EXCEPTION   syslog(LOG_NOTICE, "zerodiv = %d", 10 / 0)
#define OMIT_VGET_TIM

#elif defined(TMS320C54X)

#undef CPUEXC1				/* CPUOnhT|[gȂ */
#define STACK_SIZE	320		/* ^XÑX^bNTCY */
#define LOOP_REF	500000L		/* xvp̃[v */

#elif defined(LINUX)

#undef CPUEXC1				/* CPUOnhT|[gȂ */
#define OMIT_VGET_TIM
#define LOOP_REF	4000000		/* xvp̃[v */

#elif defined(WINDOWS)

#define LOOP_REF	5000000		/* xvp̃[v */

#endif

/*
 *  ^[QbgɈˑ\̂萔̒`
 */

#ifndef TASK_PORTID
#define	TASK_PORTID	1		/* ͂VA|[gID */
#endif /* TASK_PORTID */

#ifndef STACK_SIZE
#define	STACK_SIZE	8192		/* ^XÑX^bNTCY */
#endif /* STACK_SIZE */

#ifndef LOOP_REF
#define LOOP_REF	1000000		/* xvp̃[v */
#endif /* LOOP_REF */

/*
 *  ֐̃vg^Cv錾
 */
#ifndef _MACRO_ONLY

extern void	task(VP_INT tskno);
extern void	main_task(VP_INT exinf);
extern void	tex_routine(TEXPTN texptn, VP_INT tskno);
extern void	cyclic_handler(VP_INT exinf);
extern void	cpuexc_handler(VP p_excinf);

#endif /* _MACRO_ONLY */
