/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: itron.h,v 1.1 2008/06/17 00:04:43 suikan Exp $
 */

/*
 *	ITRONdlʋK̃f[^^E萔E}N
 *
 *  ̃t@Cɂ́CX^_[hvt@Cɂ͕KvȂ`܂
 *  Df[^^̒`́CX^_[hvt@C𖞂傤ǂ
 *  ɂ͂ĂȂD
 *
 *  AZũ\[Xt@CVXeRtBM[Vt@
 *  C炱̃t@CCN[h鎞́C_MACRO_ONLY `
 *  ƂŁC}N`ȊŐLqƂłD
 *
 *  ̃CN[ht@ĆCkernel.h  sil.h ŃCN[hD
 *  ܂CITRONdlʋKɏ\tgEFAĩCN[ht@
 *  ĆC̃t@C𒼐ڃCN[hĂ悢D̗OāC
 *  ̃t@C璼ڃCN[h邱Ƃ͂ȂD
 *
 *  ̃t@CCN[hOɁCt_stddef.h CN[h
 *  ƂKvłD
 */

#ifndef _ITRON_H_
#define _ITRON_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  JɈˑ`
 */
#include <tool_defs.h>

/*
 *  J̕WCN[ht@CiNULL  size_t ̒`Kvj
 *
 *  C++/EC++ ł́CWdl stddef.h T|[gĂƂ͌
 *  CقƂǂ̏nŃT|[gĂD
 */
#ifndef _MACRO_ONLY
#include <stddef.h>
#endif /* _MACRO_ONLY */

/*
 *  RpCˑ̃f[^^̃ftHg`
 */
#ifndef _bool_
#define	_bool_		int		/* u[^ */
#endif /* _bool_ */

/*
 *  ITRONdlʃf[^^
 */
#ifndef _MACRO_ONLY

#ifdef _int8_
typedef	signed _int8_		B;	/* t8rbg */
typedef	unsigned _int8_		UB;	/* 8rbg */
typedef	_int8_			VB;	/* ^܂Ȃ8rbg̒l */
#endif /* _int8_ */

#ifdef _int16_
typedef	signed _int16_		H;	/* t16rbg */
typedef	unsigned _int16_ 	UH;	/* 16rbg */
typedef	_int16_			VH;	/* ^܂Ȃ16rbg̒l */
#endif /* _int16_ */

typedef	signed _int32_		W;	/* t32rbg */
typedef	unsigned _int32_	UW;	/* 32rbg */
typedef	_int32_			VW;	/* ^܂Ȃ32rbg̒l */

#ifdef _int64_
typedef	signed _int64_		D;	/* t64rbg */
typedef	unsigned _int64_	UD;	/* 64rbg */
typedef	_int64_			VD;	/* ^܂Ȃ64rbg̒l */
#endif /* _int64_ */

typedef	void		*VP;		/* ^܂Ȃ̂ւ̃|C^ */
typedef	void		(*FP)();	/* vŐNԒni|C^j */

typedef signed int	INT;		/* RȃTCY̕t */
typedef unsigned int	UINT;		/* RȃTCY̕ */

typedef _bool_		BOOL;		/* ^Ul */

typedef INT		FN;		/* @\R[h */
typedef	INT		ER;		/* G[R[h */
typedef	INT		ID;		/* IuWFNgIDԍ */
typedef	UINT		ATR;		/* IuWFNg̑ */
typedef	UINT		STAT;		/* IuWFNg̏ */
typedef	UINT		MODE;		/* T[rXR[̓샂[h */
typedef	INT		PRI;		/* Dx */
typedef	size_t		SIZE;		/* ̈̃TCY */

typedef	INT		TMO;		/* ^CAEgw */
typedef	UINT		RELTIM;		/* Ύ */
typedef	UW		SYSTIM;		/* VXe */

#ifdef _vp_int_
typedef	_vp_int_	VP_INT;		/* VP ܂ INT */
#else /* _vp_int_ */
typedef	VP		VP_INT;		/* VP ܂ INT */
#endif /* _vp_int_ */

typedef	INT		ER_BOOL;	/* ER ܂ BOOL */
typedef	INT		ER_ID;		/* ER ܂ ID */
typedef	INT		ER_UINT;	/* ER ܂ UINT */

#endif /* _MACRO_ONLY */

/*
 *  ITRONdlʒ萔
 */

/*
 *  
 *
 *  _MACRO_ONLY ̎ɂ́CNULL `ȂD́C_MACRO_ONLY ̎
 *  stddef.h CN[hȂ߁CłȂ NULL ̒`
 *  HႤ\邽߂łD܂CVXeRtBM[V
 *  t@Cꍇɂ NULL `Ă͂ȂȂ߁C̓_
 *  `Ȃs悢D
 */
#ifndef _MACRO_ONLY
#ifndef NULL				/* stddef.h Ɋ܂܂Ă͂ */
#define	NULL		0		/* |C^ */
#endif /* NULL */
#endif /* _MACRO_ONLY */

#define	TRUE		1		/* ^ */
#define	FALSE		0		/* U */
#define	E_OK		0		/* I */

/*
 *  G[R[h
 */
#define	E_SYS		(-5)		/* VXeG[ */
#define	E_NOSPT		(-9)		/* T|[g@\ */
#define	E_RSFN		(-10)		/* \@\R[h */
#define	E_RSATR		(-11)		/* \񑮐 */
#define	E_PAR		(-17)		/* p[^G[ */
#define	E_ID		(-18)		/* sIDԍ */
#define	E_CTX		(-25)		/* ReLXgG[ */
#define	E_MACV		(-26)		/* ANZXᔽ */
#define	E_OACV		(-27)		/* IuWFNgANZXᔽ */
#define	E_ILUSE		(-28)		/* T[rXR[sgp */
#define	E_NOMEM		(-33)		/* s */
#define	E_NOID		(-34)		/* IDԍs */
#define	E_OBJ		(-41)		/* IuWFNgԃG[ */
#define	E_NOEXS		(-42)		/* IuWFNg */
#define	E_QOVR		(-43)		/* L[COI[o[t[ */
#define	E_RLWAI		(-49)		/* ҂Ԃ̋ */
#define	E_TMOUT		(-50)		/* |[Os܂̓^CAEg */
#define	E_DLT		(-51)		/* ҂IuWFNg̍폜 */
#define	E_CLS		(-52)		/* ҂IuWFNg̏ԕω */
#define	E_WBLK		(-57)		/* mubLOt */
#define	E_BOVR		(-58)		/* obt@I[o[t[ */

/*
 *  IuWFNg
 */
#define	TA_NULL		0u		/* IuWFNgw肵Ȃ */

/*
 *  ^CAEgw
 */
#define TMO_POL		0		/* |[O */
#define TMO_FEVR	(-1)		/* iv҂ */
#define TMO_NBLK	(-2)		/* mubLO */

/*
 *  ITRONdlʃ}N
 */

/*
 *  G[R[hE}N
 *
 *  ANSI C̋Kił́CEVtgZqi>>jg邱Ƃ
 *  ؂ĂȂ߁CSERCD}N̒`P ((ercd) >> 8) ƂƁC
 *  EVtgZq𕄍gȂRpCł́CSERCD ̕Ԓl̒l
 *  ɂȂĂ܂D
 */
#define	ERCD(mercd,sercd)	(((sercd) << 8) | ((mercd) & 0xff))

#ifdef _int8_
#define	MERCD(ercd)		((ER)((B)(ercd)))
#define	SERCD(ercd)		((ER)((B)((ercd) >> 8)))
#else /* _int8_ */
#define	MERCD(ercd)		(((ercd) & 0x80) == 0 ? ((ercd) & 0xff) \
							: ((ercd) | ~0xff))
#define	SERCD(ercd)		((~((~0) >> 8)) | ((ercd) >> 8))
#endif /* _int8_ */

#ifdef __cplusplus
}
#endif

#endif /* _ITRON_H_ */
