/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2005 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *  vZbTˑW[iXstormy16pj
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include <cpu_rename.h>

/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#include <cpu_insn.h>

/*
 *  chg_ipm/get_ipm ̓T|[gȂ
 */
#undef  SUPPORT_CHG_IPM

/*
 *  calltex ͎gpȂ
 */
#define OMIT_CALLTEX

/*
 *  VA|[g̒`
 */
#define TNUM_PORT   2   /* T|[gVA|[g̐ */

/*
 *  VA|[gԍɊւ`
 */
#define LOGTASK_PORTID  2   /* VXeOɗpVA|[gԍ */

/*
 *  O^XN̕KvX^bNTCY
 */
#define LOGTASK_STACK_SIZE 256

/*
 *  Oobt@̃TCY
 */
#define TCNT_SYSLOG_BUFFER  8

/*
 *  TCB ̃tB[h̃rbg̒`
 */
#define TBIT_TCB_TSTAT      8   /* tstat tB[h̃rbg */
#define TBIT_TCB_PRIORITY   4   /* priority tB[h̃rbg */

#ifndef _MACRO_ONLY

/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
    unsigned short sp;          /* X^bN|C^ */
    unsigned short mode;        /* dispatcher̕A */
} CTXB;

/*
 *  ^XN/^XNQƗpO[oϐ
 */
extern unsigned short _kernel_intnest ;

/*
 *  VXeԎQ
 */
#define sense_context() ( _kernel_intnest > 0)
#define sense_lock() (!( __PSW & 0x0080 ))
#define t_sense_lock sense_lock
#define i_sense_lock sense_lock
#define t_lock_cpu() ({__asm__( "clr1 psw,#7" );})
#define t_unlock_cpu() ({__asm__( "set1 psw,#7" );})
#define i_lock_cpu t_lock_cpu
#define i_unlock_cpu t_unlock_cpu

/*
 *  CPUO̔̃ReLXg̎Q
 */
#define exc_sense_context(p_excinf) ( _kernel_intnest > 1 )

/*
 *  CPUO̔CPUbNԂ̎Q
 */
#define exc_sense_lock(p_excinf) (!(((unsigned short*)p_excinf)[-1] & 0x0080))

/*
 *  ݃nh}N
 */
#define INTHDR_ENTRY(inthdr) extern void inthdr(void)
#define INT_ENTRY(inthdr) inthdr

/*
 *  CPUO}N
 */
#define EXCHDR_ENTRY(exchdr) extern void exchdr(VP sp)
#define EXC_ENTRY(exchdr) exchdr

/*
 *  vZbTˑ̏
 */
extern void cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void cpu_terminate(void);

/*
 *  ݃nh̐ݒ
 */
extern void define_inh(INHNO inhno, FP inthdr) ;

/*
 *  CPUOnh̐ݒ
 */
extern void define_exc(EXCNO excno, FP exchdr) ;

/*
 *  ^[QbgVXe̕o
 */
extern void sys_putc(char c);

/*
 *  ^XNfBXpb`
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.Sj
 */
extern void dispatch(void);

/*
 *  ^XNfBXpb`
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.Sj
 */
extern void exit_and_dispatch(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
