/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */


/*
 *	vZbTˑW[iWindowspj
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  Windows-HALƎ̃CN[ht@C
 */


/*
 *  Windows-HALƎ̒`
 */

#define FPU_CONTEXTSIZE 108     /* _jbgޔReLXg̑傫 */

/*
 *  chg_ims/ref_ims T|[g邩ǂ̒`
 */
#define	SUPPORT_CHG_IMS

/*
 *  TCB ֘A̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */

/*
 *  TCB ̃tB[h̃rbg̒`
 */
#define	TBIT_TCB_PRIORITY	8	/* priority tB[h̃rbg */
#define	TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg */


#ifndef _MACRO_ONLY

#include <s_services.h>

/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
	HANDLE	        ThreadHandle;		//^XNɊ蓖ĂꂽXbh̃nh
	DWORD		    ThreadID;			//^XNɊ蓖ĂꂽXbhID
	unsigned int    InterruptLevel;		//̃^XNĂƂ̊݃}XNx
} CTXB;

/*
 * CPUԃtO
 */
#define CPU_STAT_LOCK			0x01		//CPUbNԂł
#define CPU_STAT_EXC			0x02		//Oł
#define CPU_STAT_DOUBLEFAULT	0x04		//_utHgNĂ܂

extern volatile char CPUStatus;

/*
 *   CPUOnh
 */

/*#define EXCHNO_ZDIV  EXCEPTION_INT_DIVIDE_BY_ZERO */

/*
 *  VXeԎQ
 */

Inline BOOL
sense_context()
{
		/* ݑSłȂΔ^XNReLXgł */
	return (CurrentInterruptLevel != 0) ? TRUE : FALSE;
}

Inline BOOL
sense_lock()
{
		/* O or bNԃtOĂ CPUbNԂł */
	return (CPUStatus & (CPU_STAT_LOCK|CPU_STAT_EXC)) != 0 ? TRUE : FALSE;
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUbNƂ̉i^XNReLXgpj
 *
 *  task_intmask ́Cchg_ipm T|[g邽߂̕ϐDchg_ipm T|[
 *  gȂꍇɂ́Ctask_intmask  0 ɂȂĂƍl΂悢D
 */

#include "debugout.h"
#include "device.h"

unsigned long task_intmask;

Inline void
i_lock_cpu()
{   dis_int(0);   }

Inline void
i_unlock_cpu()
{	ena_int(0);   }

#define t_lock_cpu	i_lock_cpu
#define t_unlock_cpu	i_unlock_cpu

/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	dispatch();
extern void idispatch();

/*
 *  ݂̃ReLXĝĂăfBXpb`
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */

extern void    exit_and_dispatch(void);

/*
 *  ݃nh^CPUOnh̐ݒ
 */


/*
 *  ݃nh̐ݒ
 *
 *  xNgԍ inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 */

Inline void
define_inh(INHNO inhno, FP inthdr)
{	def_int((unsigned int)inhno,(void *)inthdr);   }

/*
 *  CPUOnh̐ݒ
 *
 *  xNgԍ excno CPUOnh̋NԒn exchdr ɐݒ肷D
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{	def_exc( (DWORD)excno, (void *)exchdr);   }

/*
 *  ݃nh^CPUOnh̏o
 */

/*
 *  ݃nh̏o̐}N
 *
 *  SĂ̊荞݃nh̓fBXpb`NSIGUSR1}XN
 *  삷B
 *  reqflg `FbNOɊ݂֎~ȂƁCreqflg `FbN
 *  ɋNꂽ݃nhŃfBXpb`vꂽꍇɁCfB
 *  Xpb`ȂD
 */

	/* Windows-HALɂĂ̏͊݃G~[^ɈCĂ */

#define INT_ENTRY(hdr) hdr
#define INTHDR_ENTRY(inthdr) extern void inthdr(void)

/*
 *  CPUOnh̏o̐}N
 *
 *  CPUOnh́C^XNReLXgŎsD̂߁CCPU
 *  OnhĂяoOɊ݃[hɈڍsC^[Ă
 *  ̃[hɖ߂D̃[hɖ߂߂ɁC݃[hɈڍsO
 *   SR ݃X^bNɕۑDCPUO^XNReLXg
 *  Creqflg  TRUE ɂȂɁCret_exc ֕򂷂D
 *  reqflg `FbNOɊ݂֎~ȂƁCreqflg `FbN
 *  ɋNꂽ݃nhŃfBXpb`vꂽꍇɁCfB
 *  Xpb`ȂD
 */

#define EXC_ENTRY(hdr) hdr
#define EXCHDR_ENTRY(inthdr) extern void inthdr(void)

/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃fBXpb`
 *
 *   WindowsHAL͐ptOĂŁAݑȌ͂̂܂
 *   i[ĂB
 */
#define exc_sense_context sense_context

/*
 *  CPUO̔CPUbNԂ̎Q
 */
#define exc_sense_lock sense_lock

/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);

/*
 *  atexitœo^ꂽ֐̓Ǐo (Windows͉Ȃ -> CRTɔC)
 */
extern void	call_atexit(void);

/*
 *   Windows Dedicated Routines 
 */
extern LONG WINAPI HALExceptionHandler( EXCEPTION_POINTERS * exc );

/*
 *   vIȎsɑ΂Ώ[`
 */
extern void FatalAssertion(int exp, LPCSTR format, ... );


/*
 *   Ȍo͐䃋[`
 */
extern void set_logcontrol(BOOL enable);

/*
 *   J[lfobOpprintf
 */

#ifdef KERNEL_DEBUG_MODE
#  define kprintf(x) _kernel_debugprintf x
#else
#  define kprintf(x)
#endif

extern void _kernel_debugprintf(const char * format, ... );

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
