/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2005 by Freelines CO.,Ltd 
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: v850es_sg2.h,v 1.1 2008/06/17 00:04:46 suikan Exp $
 */

#ifndef	_V850ES_SG2_H_
#define	_V850ES_SG2_H_
/*
 *	vZbTɈˑ`iV850pj
 */
#ifndef _MACRO_ONLY
typedef unsigned char   byte;
typedef unsigned short  word;
typedef unsigned long   dword;
typedef volatile byte   IOREG;
typedef volatile word   HIOREG;
typedef volatile dword  LIOREG;
#endif /* _MACRO_ONLY */

/*
 * RAM
 */
#define	IRAM_TOP	0x03FF7000		/* RAM̐擪AhX */
#define IRAM_SIZE	0x8000			/* RAM̑傫 32Kbyte(uPD70F3281Y) */
/*
 * FlashROM
 */
#define	IROM_TOP	0x0000000		/* FlashROM̐擪AhX */
#define IROM_SIZE	0x60000			/* FlashROM̑傫 384Kbyte(uPD70F3281Y) */

/* 
 * V850ES/SG2IOWX^`
 */
#define	PDL			0xFFFFF004		/* |[gDLWX^ */
#define	PDLL		0xFFFFF004		/* |[gDLWX^L */
#define	PDLH		0xFFFFF005		/* |[gDLWX^H */
#define	PDH			0xFFFFF006		/* |[gDHWX^ */
#define	PCT			0xFFFFF00A		/* |[gCTWX^ */
#define	PCM			0xFFFFF00C		/* |[gCMWX^ */
#define	PMDL		0xFFFFF024		/* |[gDL[hEWX^ */
#define	PMDLL		0xFFFFF024		/* |[gDL[hEWX^L */
#define	PMDLH		0xFFFFF025		/* |[gDL[hEWX^H */
#define	PMDH		0xFFFFF026		/* |[gDH[hEWX^ */
#define	PMCT		0xFFFFF02A		/* |[gCT[hEWX^ */
#define	PMCM		0xFFFFF02C		/* |[gCM[hEWX^ */
#define	PMCDL		0xFFFFF044		/* |[gDL[hERg[EWX^ */
#define	PMCDLL		0xFFFFF044		/* |[gDL[hERg[EWX^L */
#define	PMCDLH		0xFFFFF045		/* |[gDL[hERg[EWX^H */
#define	PMCDH		0xFFFFF046		/* |[gDH[hERg[EWX^ */
#define	PMCCT		0xFFFFF04A		/* |[gCT[hERg[EWX^ */
#define	PMCCM		0xFFFFF04C		/* |[gCM[hERg[EWX^ */
#define	BPC			0xFFFFF064		/* I/ÖZNg䃌WX^ */
#define	BSC			0xFFFFF066		/* oXETCYERtBM[VEWX^EoX */
#define	VSWC		0xFFFFF06E		/* VXeEEGCgERg[EWX^ */
#define	DSA0L		0xFFFFF080		/* DMA\[XEAhXEWX^0L */
#define	DSA0H		0xFFFFF082		/* DMA\[XEAhXEWX^0H */
#define	DDA0L		0xFFFFF084		/* DMAfXeBl[VEAhXEWX^0L */
#define	DDA0H		0xFFFFF086		/* DMAfXeBl[VEAhXEWX^0H */
#define	DSA1L		0xFFFFF088		/* DMA\[XEAhXEWX^1L */
#define	DSA1H		0xFFFFF08A		/* DMA\[XEAhXEWX^1H */
#define	DDA1L		0xFFFFF08C		/* DMAfXeBl[VEAhXEWX^1L */
#define	DDA1H		0xFFFFF08E		/* DMAfXeBl[VEAhXEWX^1H */
#define	DSA2L		0xFFFFF090		/* DMA\[XEAhXEWX^2L */
#define	DSA2H		0xFFFFF092		/* DMA\[XEAhXEWX^2H */
#define	DDA2L		0xFFFFF094		/* DMAfXeBl[VEAhXEWX^2L */
#define	DDA2H		0xFFFFF096		/* DMAfXeBl[VEAhXEWX^2H */
#define	DSA3L		0xFFFFF098		/* DMA\[XEAhXEWX^3L */
#define	DSA3H		0xFFFFF09A		/* DMA\[XEAhXEWX^3H */
#define	DDA3L		0xFFFFF09C		/* DMAfXeBl[VEAhXEWX^3L */
#define	DDA3H		0xFFFFF09E		/* DMAfXeBl[VEAhXEWX^3H */
#define	DBC0		0xFFFFF0C0		/* DMA]JEgEWX^0 */
#define	DBC1		0xFFFFF0C2		/* DMA]JEgEWX^1 */
#define	DBC2		0xFFFFF0C4		/* DMA]JEgEWX^2 */
#define	DBC3		0xFFFFF0C6		/* DMA]JEgEWX^3 */
#define	DADC0		0xFFFFF0D0		/* DMAAhVOERg[EWX^0 */
#define	DADC1		0xFFFFF0D2		/* DMAAhVOERg[EWX^1 */
#define	DADC2		0xFFFFF0D4		/* DMAAhVOERg[EWX^2 */
#define	DADC3		0xFFFFF0D6		/* DMAAhVOERg[EWX^3 */
#define	DCHC0		0xFFFFF0E0		/* DMA`lERg[EWX^0 */
#define	DCHC1		0xFFFFF0E2		/* DMA`lERg[EWX^1 */
#define	DCHC2		0xFFFFF0E4		/* DMA`lERg[EWX^2 */
#define	DCHC3		0xFFFFF0E6		/* DMA`lERg[EWX^3 */
#define	IMR0		0xFFFFF100		/* 荞݃}XNEWX^0 */
#define	IMR0L		0xFFFFF100		/* 荞݃}XNEWX^0L */
#define	IMR0H		0xFFFFF101		/* 荞݃}XNEWX^0H */
#define	IMR1		0xFFFFF102		/* 荞݃}XNEWX^1 */
#define	IMR1L		0xFFFFF102		/* 荞݃}XNEWX^1L */
#define	IMR1H		0xFFFFF103		/* 荞݃}XNEWX^1H */
#define	IMR2		0xFFFFF104		/* 荞݃}XNEWX^2 */
#define	IMR2L		0xFFFFF104		/* 荞݃}XNEWX^2L */
#define	IMR2H		0xFFFFF105		/* 荞݃}XNEWX^2H */
#define	IMR3		0xFFFFF106		/* 荞݃}XNEWX^3 */
#define	IMR3L		0xFFFFF106		/* 荞݃}XNEWX^3L */
#define	IMR3H		0xFFFFF107		/* 荞݃}XNEWX^3H */
#define	LVIIC		0xFFFFF110		/* 荞ݐ䃌WX^ */
#define	PIC0		0xFFFFF112		/* 荞ݐ䃌WX^ */
#define	PIC1		0xFFFFF114		/* 荞ݐ䃌WX^ */
#define	PIC2		0xFFFFF116		/* 荞ݐ䃌WX^ */
#define	PIC3		0xFFFFF118		/* 荞ݐ䃌WX^ */
#define	PIC4		0xFFFFF11A		/* 荞ݐ䃌WX^ */
#define	PIC5		0xFFFFF11C		/* 荞ݐ䃌WX^ */
#define	PIC6		0xFFFFF11E		/* 荞ݐ䃌WX^ */
#define	PIC7		0xFFFFF120		/* 荞ݐ䃌WX^ */
#define	TQ0OVIC		0xFFFFF122		/* 荞ݐ䃌WX^ */
#define	TQ0CCIC0	0xFFFFF124		/* 荞ݐ䃌WX^ */
#define	TQ0CCIC1	0xFFFFF126		/* 荞ݐ䃌WX^ */
#define	TQ0CCIC2	0xFFFFF128		/* 荞ݐ䃌WX^ */
#define	TQ0CCIC3	0xFFFFF12A		/* 荞ݐ䃌WX^ */
#define	TP0OVIC		0xFFFFF12C		/* 荞ݐ䃌WX^ */
#define	TP0CCIC0	0xFFFFF12E		/* 荞ݐ䃌WX^ */
#define	TP0CCIC1	0xFFFFF130		/* 荞ݐ䃌WX^ */
#define	TP1OVIC		0xFFFFF132		/* 荞ݐ䃌WX^ */
#define	TP1CCIC0	0xFFFFF134		/* 荞ݐ䃌WX^ */
#define	TP1CCIC1	0xFFFFF136		/* 荞ݐ䃌WX^ */
#define	TP2OVIC		0xFFFFF138		/* 荞ݐ䃌WX^ */
#define	TP2CCIC0	0xFFFFF13A		/* 荞ݐ䃌WX^ */
#define	TP2CCIC1	0xFFFFF13C		/* 荞ݐ䃌WX^ */
#define	TP3OVIC		0xFFFFF13E		/* 荞ݐ䃌WX^ */
#define	TP3CCIC0	0xFFFFF140		/* 荞ݐ䃌WX^ */
#define	TP3CCIC1	0xFFFFF142		/* 荞ݐ䃌WX^ */
#define	TP4OVIC		0xFFFFF144		/* 荞ݐ䃌WX^ */
#define	TP4CCIC0	0xFFFFF146		/* 荞ݐ䃌WX^ */
#define	TP4CCIC1	0xFFFFF148		/* 荞ݐ䃌WX^ */
#define	TP5OVIC		0xFFFFF14A		/* 荞ݐ䃌WX^ */
#define	TP5CCIC0	0xFFFFF14C		/* 荞ݐ䃌WX^ */
#define	TP5CCIC1	0xFFFFF14E		/* 荞ݐ䃌WX^ */
#define	TM0EQIC0	0xFFFFF150		/* 荞ݐ䃌WX^ */
#define	CB0RIC		0xFFFFF152		/* 荞ݐ䃌WX^ */
#define	IICIC1		0xFFFFF152		/* 荞ݐ䃌WX^ */
#define	CB0TIC		0xFFFFF154		/* 荞ݐ䃌WX^ */
#define	CB1RIC		0xFFFFF156		/* 荞ݐ䃌WX^ */
#define	CB1TIC		0xFFFFF158		/* 荞ݐ䃌WX^ */
#define	CB2RIC		0xFFFFF15A		/* 荞ݐ䃌WX^ */
#define	CB2TIC		0xFFFFF15C		/* 荞ݐ䃌WX^ */
#define	CB3RIC		0xFFFFF15E		/* 荞ݐ䃌WX^ */
#define	CB3TIC		0xFFFFF160		/* 荞ݐ䃌WX^ */
#define	UA0RIC		0xFFFFF162		/* 荞ݐ䃌WX^ */
#define	CB4RIC		0xFFFFF162		/* 荞ݐ䃌WX^ */
#define	UA0TIC		0xFFFFF164		/* 荞ݐ䃌WX^ */
#define	CB4TIC		0xFFFFF164		/* 荞ݐ䃌WX^ */
#define	UA1RIC		0xFFFFF166		/* 荞ݐ䃌WX^ */
#define	IICIC2		0xFFFFF166		/* 荞ݐ䃌WX^ */
#define	UA1TIC		0xFFFFF168		/* 荞ݐ䃌WX^ */
#define	UA2RIC		0xFFFFF16A		/* 荞ݐ䃌WX^ */
#define	IICIC0		0xFFFFF16A		/* 荞ݐ䃌WX^ */
#define	UA2TIC		0xFFFFF16C		/* 荞ݐ䃌WX^ */
#define	ADIC		0xFFFFF16E		/* 荞ݐ䃌WX^ */
#define	DMAIC0		0xFFFFF170		/* 荞ݐ䃌WX^ */
#define	DMAIC1		0xFFFFF172		/* 荞ݐ䃌WX^ */
#define	DMAIC2		0xFFFFF174		/* 荞ݐ䃌WX^ */
#define	DMAIC3		0xFFFFF176		/* 荞ݐ䃌WX^ */
#define	KRIC		0xFFFFF178		/* 荞ݐ䃌WX^ */
#define	WTIIC		0xFFFFF17A		/* 荞ݐ䃌WX^ */
#define	WTIC		0xFFFFF17C		/* 荞ݐ䃌WX^ */
#define	ERRIC0		0xFFFFF17E		/* 荞ݐ䃌WX^ */
#define	ERRIC		0xFFFFF17E		/* 荞ݐ䃌WX^ */
#define	WUPIC0		0xFFFFF180		/* 荞ݐ䃌WX^ */
#define	STAIC		0xFFFFF180		/* 荞ݐ䃌WX^ */
#define	RECIC0		0xFFFFF182		/* 荞ݐ䃌WX^ */
#define	IEIC1		0xFFFFF182		/* 荞ݐ䃌WX^ */
#define	TRXIC0		0xFFFFF184		/* 荞ݐ䃌WX^ */
#define	IEIC2		0xFFFFF184		/* 荞ݐ䃌WX^ */
#define	ISPR		0xFFFFF1FA		/* CT[rXEvCIeBEWX^ */
#define	PRCMD		0xFFFFF1FC		/* R}hEWX^ */
#define	PSC			0xFFFFF1FE		/* p[EZ[uERg[EWX^ */
#define	ADA0M0		0xFFFFF200		/* A/DRo[^E[hEWX^0 */
#define	ADA0M1		0xFFFFF201		/* A/DRo[^E[hEWX^1 */
#define	ADA0S		0xFFFFF202		/* A/DRo[^E`lw背WX^ */
#define	ADA0M2		0xFFFFF203		/* A/DRo[^E[hEWX^2 */
#define	ADA0PFM		0xFFFFF204		/* p[EtFCr[hEWX^ */
#define	ADA0PFT		0xFFFFF205		/* p[EtFCrlWX^ */
#define	ADA0CR0		0xFFFFF210		/* A/DϊʃWX^0 */
#define	ADA0CR0H	0xFFFFF211		/* A/DϊʃWX^0H */
#define	ADA0CR1		0xFFFFF212		/* A/DϊʃWX^1 */
#define	ADA0CR1H	0xFFFFF213		/* A/DϊʃWX^1H */
#define	ADA0CR2		0xFFFFF214		/* A/DϊʃWX^2 */
#define	ADA0CR2H	0xFFFFF215		/* A/DϊʃWX^2H */
#define	ADA0CR3		0xFFFFF216		/* A/DϊʃWX^3 */
#define	ADA0CR3H	0xFFFFF217		/* A/DϊʃWX^3H */
#define	ADA0CR4		0xFFFFF218		/* A/DϊʃWX^4 */
#define	ADA0CR4H	0xFFFFF219		/* A/DϊʃWX^4H */
#define	ADA0CR5		0xFFFFF21A		/* A/DϊʃWX^5 */
#define	ADA0CR5H	0xFFFFF21B		/* A/DϊʃWX^5H */
#define	ADA0CR6		0xFFFFF21C		/* A/DϊʃWX^6 */
#define	ADA0CR6H	0xFFFFF21D		/* A/DϊʃWX^6H */
#define	ADA0CR7		0xFFFFF21E		/* A/DϊʃWX^7 */
#define	ADA0CR7H	0xFFFFF21F		/* A/DϊʃWX^7H */
#define	ADA0CR8		0xFFFFF220		/* A/DϊʃWX^8 */
#define	ADA0CR8H	0xFFFFF221		/* A/DϊʃWX^8H */
#define	ADA0CR9		0xFFFFF222		/* A/DϊʃWX^9 */
#define	ADA0CR9H	0xFFFFF223		/* A/DϊʃWX^9H */
#define	ADA0CR10	0xFFFFF224		/* A/DϊʃWX^10 */
#define	ADA0CR10H	0xFFFFF225		/* A/DϊʃWX^10H */
#define	ADA0CR11	0xFFFFF226		/* A/DϊʃWX^11 */
#define	ADA0CR11H	0xFFFFF227		/* A/DϊʃWX^11H */
#define	DA0CS0		0xFFFFF280		/* D/ARo[^ϊlݒ背WX^0 */
#define	DA0CS1		0xFFFFF281		/* D/ARo[^ϊlݒ背WX^1 */
#define	DA0M		0xFFFFF282		/* D/ARo[^E[hEWX^ */
#define	KRM			0xFFFFF300		/* L[E^[E[hEWX^ */
#define	SELCNT0		0xFFFFF308		/* ZN^쐧䃌WX^ */
#define	CRCIN		0xFFFFF310		/* CRCCvbgEWX^ */
#define	CRCD		0xFFFFF312		/* CRCf[^EWX^ */
#define	NFC			0xFFFFF318		/* mCY䃌WX^ */
#define	PRSM1		0xFFFFF320		/* BRG1vXP[E[hEWX^ */
#define	PRSCM1		0xFFFFF321		/* BRG1vXP[ERyAEWX^ */
#define	PRSM2		0xFFFFF324		/* BRG2vXP[E[hEWX^ */
#define	PRSCM2		0xFFFFF325		/* BRG2vXP[ERyAEWX^ */
#define	PRSM3		0xFFFFF328		/* BRG3vXP[E[hEWX^ */
#define	PRSCM3		0xFFFFF329		/* BRG3vXP[ERyAEWX^ */
#define	OCKS0		0xFFFFF340		/* IICNbNIWX^0 */
#define	OCKS1		0xFFFFF344		/* IICNbNIWX^1 */
#define	OCKS2		0xFFFFF348		/* IEBusNbNIWX^ */
#define	BCR			0xFFFFF360		/* IEBusRg[EWX^ */
#define	PSR			0xFFFFF361		/* IEBusp[EZ[uEWX^ */
#define	SSR			0xFFFFF362		/* IEBusX[uEXe[^XEWX^ */
#define	USR			0xFFFFF363		/* IEBusjbgEXe[^XEWX^ */
#define	ISR			0xFFFFF364		/* IEBusC^vgEXe[^XEWX^ */
#define	ESR			0xFFFFF365		/* IEBusG[EXe[^XEWX^ */
#define	UAR			0xFFFFF366		/* IEBusjbgEAhXEWX^ */
#define	SAR			0xFFFFF368		/* IEBusX[uEAhXEWX^ */
#define	PAR			0xFFFFF36A		/* IEBusp[giEAhXEWX^ */
#define	RSA			0xFFFFF36C		/* IEBusMX[uEAhXEWX^ */
#define	CDR			0xFFFFF36E		/* IEBusRg[Ef[^EWX^ */
#define	DLR			0xFFFFF36F		/* IEBusdWX^ */
#define	DR			0xFFFFF370		/* IEBusf[^EWX^ */
#define	FSR			0xFFFFF371		/* IEBustB[hEXe[^XEWX^ */
#define	SCR			0xFFFFF372		/* IEBusTNZXEJEgEWX^ */
#define	CCR			0xFFFFF373		/* IEBusR~jP[VEJEgEWX^ */
#define	P0			0xFFFFF400		/* |[g0WX^ */
#define	P1			0xFFFFF402		/* |[g1WX^ */
#define	P3			0xFFFFF406		/* |[g3WX^ */
#define	P3L			0xFFFFF406		/* |[g3WX^L */
#define	P3H			0xFFFFF407		/* |[g3WX^H */
#define	P4			0xFFFFF408		/* |[g4WX^ */
#define	P5			0xFFFFF40A		/* |[g5WX^ */
#define	P7L			0xFFFFF40E		/* |[g7WX^L */
#define	P7H			0xFFFFF40F		/* |[g7WX^H */
#define	P9			0xFFFFF412		/* |[g9WX^ */
#define	P9L			0xFFFFF412		/* |[g9WX^L */
#define	P9H			0xFFFFF413		/* |[g9WX^H */
#define	PM0			0xFFFFF420		/* |[g0[hEWX^ */
#define	PM1			0xFFFFF422		/* |[g1[hEWX^ */
#define	PM3			0xFFFFF426		/* |[g3[hEWX^ */
#define	PM3L		0xFFFFF426		/* |[g3[hEWX^L */
#define	PM3H		0xFFFFF427		/* |[g3[hEWX^H */
#define	PM4			0xFFFFF428		/* |[g4[hEWX^ */
#define	PM5			0xFFFFF42A		/* |[g5[hEWX^ */
#define	PM7L		0xFFFFF42E		/* |[g7[hEWX^L */
#define	PM7H		0xFFFFF42F		/* |[g7[hEWX^H */
#define	PM9			0xFFFFF432		/* |[g9[hEWX^ */
#define	PM9L		0xFFFFF432		/* |[g9[hEWX^L */
#define	PM9H		0xFFFFF433		/* |[g9[hEWX^H */
#define	PMC0		0xFFFFF440		/* |[g0[hERg[EWX^ */
#define	PMC3		0xFFFFF446		/* |[g3[hERg[EWX^ */
#define	PMC3L		0xFFFFF446		/* |[g3[hERg[EWX^L */
#define	PMC3H		0xFFFFF447		/* |[g3[hERg[EWX^H */
#define	PMC4		0xFFFFF448		/* |[g4[hERg[EWX^ */
#define	PMC5		0xFFFFF44A		/* |[g5[hERg[EWX^ */
#define	PMC9		0xFFFFF452		/* |[g9[hERg[EWX^ */
#define	PMC9L		0xFFFFF452		/* |[g9[hERg[EWX^L */
#define	PMC9H		0xFFFFF453		/* |[g9[hERg[EWX^H */
#define	PFC0		0xFFFFF460		/* |[g0t@NVERg[EWX^ */
#define	PFC3		0xFFFFF466		/* |[g3t@NVERg[EWX^ */
#define	PFC3L		0xFFFFF466		/* |[g3t@NVERg[EWX^L */
#define	PFC3H		0xFFFFF467		/* |[g3t@NVERg[EWX^H */
#define	PFC4		0xFFFFF468		/* |[g4t@NVERg[EWX^ */
#define	PFC5		0xFFFFF46A		/* |[g5t@NVERg[EWX^ */
#define	PFC9		0xFFFFF472		/* |[g9t@NVERg[EWX^ */
#define	PFC9L		0xFFFFF472		/* |[g9t@NVERg[EWX^L */
#define	PFC9H		0xFFFFF473		/* |[g9t@NVERg[EWX^H */
#define	DWC0		0xFFFFF484		/* f[^EEGCgERg[EWX^0 */
#define	AWC			0xFFFFF488		/* AhXEEGCgERg[EWX^ */
#define	BCC			0xFFFFF48A		/* oXETCNERg[EWX^ */
#define	TQ0CTL0		0xFFFFF540		/* TMQ0䃌WX^0 */
#define	TQ0CTL1		0xFFFFF541		/* TMQ0䃌WX^1 */
#define	TQ0IOC0		0xFFFFF542		/* TMQ0I/O䃌WX^0 */
#define	TQ0IOC1		0xFFFFF543		/* TMQ0I/O䃌WX^1 */
#define	TQ0IOC2		0xFFFFF544		/* TMQ0I/O䃌WX^2 */
#define	TQ0OPT0		0xFFFFF545		/* TMQ0IvVEWX^ */
#define	TQ0CCR0		0xFFFFF546		/* TMQ0Lv`^RyAEWX^0 */
#define	TQ0CCR1		0xFFFFF548		/* TMQ0Lv`^RyAEWX^1 */
#define	TQ0CCR2		0xFFFFF54A		/* TMQ0Lv`^RyAEWX^2 */
#define	TQ0CCR3		0xFFFFF54C		/* TMQ0Lv`^RyAEWX^3 */
#define	TQ0CNT		0xFFFFF54E		/* TMQ0JE^E[hEobt@EWX^ */
#define	TP0CTL0		0xFFFFF590		/* TMP0䃌WX^0 */
#define	TP0CTL1		0xFFFFF591		/* TMP0䃌WX^1 */
#define	TP0IOC0		0xFFFFF592		/* TMP0I/O䃌WX^0 */
#define	TP0IOC1		0xFFFFF593		/* TMP0I/O䃌WX^1 */
#define	TP0IOC2		0xFFFFF594		/* TMP0I/O䃌WX^2 */
#define	TP0OPT0		0xFFFFF595		/* TMP0IvVEWX^ */
#define	TP0CCR0		0xFFFFF596		/* TMP0Lv`^RyAEWX^0 */
#define	TP0CCR1		0xFFFFF598		/* TMP0Lv`^RyAEWX^1 */
#define	TP0CNT		0xFFFFF59A		/* TMP0JE^E[hEobt@EWX^ */
#define	TP1CTL0		0xFFFFF5A0		/* TMP1䃌WX^0 */
#define	TP1CTL1		0xFFFFF5A1		/* TMP1䃌WX^1 */
#define	TP1IOC0		0xFFFFF5A2		/* TMP1I/O䃌WX^0 */
#define	TP1IOC1		0xFFFFF5A3		/* TMP1I/O䃌WX^1 */
#define	TP1IOC2		0xFFFFF5A4		/* TMP1I/O䃌WX^2 */
#define	TP1OPT0		0xFFFFF5A5		/* TMP1IvVEWX^ */
#define	TP1CCR0		0xFFFFF5A6		/* TMP1Lv`^RyAEWX^0 */
#define	TP1CCR1		0xFFFFF5A8		/* TMP1Lv`^RyAEWX^1 */
#define	TP1CNT		0xFFFFF5AA		/* TMP1JE^E[hEobt@EWX^ */
#define	TP2CTL0		0xFFFFF5B0		/* TMP2䃌WX^0 */
#define	TP2CTL1		0xFFFFF5B1		/* TMP2䃌WX^1 */
#define	TP2IOC0		0xFFFFF5B2		/* TMP2I/O䃌WX^0 */
#define	TP2IOC1		0xFFFFF5B3		/* TMP2I/O䃌WX^1 */
#define	TP2IOC2		0xFFFFF5B4		/* TMP2I/O䃌WX^2 */
#define	TP2OPT0		0xFFFFF5B5		/* TMP2IvVEWX^ */
#define	TP2CCR0		0xFFFFF5B6		/* TMP2Lv`^RyAEWX^0 */
#define	TP2CCR1		0xFFFFF5B8		/* TMP2Lv`^RyAEWX^1 */
#define	TP2CNT		0xFFFFF5BA		/* TMP2JE^E[hEobt@EWX^ */
#define	TP3CTL0		0xFFFFF5C0		/* TMP3䃌WX^0 */
#define	TP3CTL1		0xFFFFF5C1		/* TMP3䃌WX^1 */
#define	TP3IOC0		0xFFFFF5C2		/* TMP3I/O䃌WX^0 */
#define	TP3IOC1		0xFFFFF5C3		/* TMP3I/O䃌WX^1 */
#define	TP3IOC2		0xFFFFF5C4		/* TMP3I/O䃌WX^2 */
#define	TP3OPT0		0xFFFFF5C5		/* TMP3IvVEWX^ */
#define	TP3CCR0		0xFFFFF5C6		/* TMP3Lv`^RyAEWX^0 */
#define	TP3CCR1		0xFFFFF5C8		/* TMP3Lv`^RyAEWX^1 */
#define	TP3CNT		0xFFFFF5CA		/* TMP3JE^E[hEobt@EWX^ */
#define	TP4CTL0		0xFFFFF5D0		/* TMP4䃌WX^0 */
#define	TP4CTL1		0xFFFFF5D1		/* TMP4䃌WX^1 */
#define	TP4IOC0		0xFFFFF5D2		/* TMP4I/O䃌WX^0 */
#define	TP4IOC1		0xFFFFF5D3		/* TMP4I/O䃌WX^1 */
#define	TP4IOC2		0xFFFFF5D4		/* TMP4I/O䃌WX^2 */
#define	TP4OPT0		0xFFFFF5D5		/* TMP4IvVEWX^ */
#define	TP4CCR0		0xFFFFF5D6		/* TMP4Lv`^RyAEWX^0 */
#define	TP4CCR1		0xFFFFF5D8		/* TMP4Lv`^RyAEWX^1 */
#define	TP4CNT		0xFFFFF5DA		/* TMP4JE^E[hEobt@EWX^ */
#define	TP5CTL0		0xFFFFF5E0		/* TMP5䃌WX^0 */
#define	TP5CTL1		0xFFFFF5E1		/* TMP5䃌WX^1 */
#define	TP5IOC0		0xFFFFF5E2		/* TMP5I/O䃌WX^0 */
#define	TP5IOC1		0xFFFFF5E3		/* TMP5I/O䃌WX^1 */
#define	TP5IOC2		0xFFFFF5E4		/* TMP5I/O䃌WX^2 */
#define	TP5OPT0		0xFFFFF5E5		/* TMP5IvVEWX^ */
#define	TP5CCR0		0xFFFFF5E6		/* TMP5Lv`^RyAEWX^0 */
#define	TP5CCR1		0xFFFFF5E8		/* TMP5Lv`^RyAEWX^1 */
#define	TP5CNT		0xFFFFF5EA		/* TMP5JE^E[hEobt@EWX^ */
#define	WTM			0xFFFFF680		/* v^C}샂[hEWX^ */
#define	TM0CTL0		0xFFFFF690		/* TMM0䃌WX^0 */
#define	TM0CMP0		0xFFFFF694		/* TMM0RyAEWX^0 */
#define	OSTS		0xFFFFF6C0		/* U莞ԑIWX^ */
#define	PLLS		0xFFFFF6C1		/* PLLbNAbvԎw背WX^ */
#define	WDTM2		0xFFFFF6D0		/* EHb`hbOE^C}E[hEWX^2 */
#define	WDTE		0xFFFFF6D1		/* EHb`hbOE^C}ECl[uEWX^ */
#define	RTBL0		0xFFFFF6E0		/* A^Co̓obt@EWX^0k */
#define	RTBH0		0xFFFFF6E2		/* A^Co̓obt@EWX^0H */
#define	RTPM0		0xFFFFF6E4		/* A^Co̓|[gE[hEWX^0 */
#define	RTPC0		0xFFFFF6E5		/* A^Co̓|[gERg[EWX^0 */
#define	PFCE3L		0xFFFFF706		/* |[g3t@NVERg[gWX^L */
#define	PFCE5		0xFFFFF70A		/* |[g5t@NVERg[gWX^ */
#define	PFCE9		0xFFFFF712		/* |[g9t@NVERg[gWX^ */
#define	PFCE9L		0xFFFFF712		/* |[g9t@NVERg[gWX^L */
#define	PFCE9H		0xFFFFF713		/* |[g9t@NVERg[gWX^H */
#define	SYS			0xFFFFF802		/* VXeEXe[^XEWX^ */
#define	RCM			0xFFFFF80C		/* OOSC[hEWX^ */
#define	DTFR0		0xFFFFF810		/* DMAgKvWX^0 */
#define	DTFR1		0xFFFFF812		/* DMAgKvWX^1 */
#define	DTFR2		0xFFFFF814		/* DMAgKvWX^2 */
#define	DTFR3		0xFFFFF816		/* DMAgKvWX^3 */
#define	PSMR		0xFFFFF820		/* p[EZ[uE[hEWX^ */
#define	CKC			0xFFFFF822		/* NbNERg[EWX^ */
#define	LOCKR		0xFFFFF824		/* bNEWX^ */
#define	PCC			0xFFFFF828		/* vZbTENbNERg[EWX^ */
#define	PLLCTL		0xFFFFF82C		/* PLLRg[EWX^ */
#define	CCLS		0xFFFFF82E		/* CPUNbNEXe[^XEWX^ */
#define	CORAD0		0xFFFFF840		/* RNVEAhXEWX^0 */
#define	CORAD0L		0xFFFFF840		/* RNVEAhXEWX^0L */
#define	CORAD0H		0xFFFFF842		/* RNVEAhXEWX^0H */
#define	CORAD1		0xFFFFF844		/* RNVEAhXEWX^1 */
#define	CORAD1L		0xFFFFF844		/* RNVEAhXEWX^1L */
#define	CORAD1H		0xFFFFF846		/* RNVEAhXEWX^1H */
#define	CORAD2		0xFFFFF848		/* RNVEAhXEWX^2 */
#define	CORAD2L		0xFFFFF848		/* RNVEAhXEWX^2L */
#define	CORAD2H		0xFFFFF84A		/* RNVEAhXEWX^2H */
#define	CORAD3		0xFFFFF84C		/* RNVEAhXEWX^3 */
#define	CORAD3L		0xFFFFF84C		/* RNVEAhXEWX^3L */
#define	CORAD3H		0xFFFFF84E		/* RNVEAhXEWX^3H */
#define	CLM			0xFFFFF870		/* NbNEj^E[hEWX^ */
#define	CORCN		0xFFFFF880		/* RNVERg[EWX^ */
#define	RESF		0xFFFFF888		/* ZbgvtOEWX^ */
#define	LVIM		0xFFFFF890		/* doWX^ */
#define	LVIS		0xFFFFF891		/* doxIWX^ */
#define	RAMS		0xFFFFF892		/* RAMf[^EXe[^XEWX^ */
#define	PRSM0		0xFFFFF8B0		/* vXP[E[hEWX^ */
#define	PRSCM0		0xFFFFF8B1		/* vXP[ERyAEWX^ */
#define	OCDM		0xFFFFF9FC		/* I`bvEfBoOE[hEWX^ */
#define	PEMU1		0xFFFFF9FE		/* ӃG~[VEWX^1 */
#define	UA0CTL0		0xFFFFFA00		/* UARTA0䃌WX^0 */
#define	UA0CTL1		0xFFFFFA01		/* UARTA0䃌WX^1 */
#define	UA0CTL2		0xFFFFFA02		/* UARTA0䃌WX^2 */
#define	UA0OPT0		0xFFFFFA03		/* UARTA0IvV䃌WX^0 */
#define	UA0STR		0xFFFFFA04		/* UARTA0ԃWX^ */
#define	UA0RX		0xFFFFFA06		/* UARTA0Mf[^EWX^ */
#define	UA0TX		0xFFFFFA07		/* UARTA0Mf[^EWX^ */
#define	UA1CTL0		0xFFFFFA10		/* UARTA1䃌WX^0 */
#define	UA1CTL1		0xFFFFFA11		/* UARTA1䃌WX^1 */
#define	UA1CTL2		0xFFFFFA12		/* UARTA1䃌WX^2 */
#define	UA1OPT0		0xFFFFFA13		/* UARTA1IvV䃌WX^0 */
#define	UA1STR		0xFFFFFA14		/* UARTA1ԃWX^ */
#define	UA1RX		0xFFFFFA16		/* UARTA1Mf[^EWX^ */
#define	UA1TX		0xFFFFFA17		/* UARTA1Mf[^EWX^ */
#define	UA2CTL0		0xFFFFFA20		/* UARTA2䃌WX^0 */
#define	UA2CTL1		0xFFFFFA21		/* UARTA2䃌WX^1 */
#define	UA2CTL2		0xFFFFFA22		/* UARTA2䃌WX^2 */
#define	UA2OPT0		0xFFFFFA23		/* UARTA2IvV䃌WX^0 */
#define	UA2STR		0xFFFFFA24		/* UARTA2ԃWX^ */
#define	UA2RX		0xFFFFFA26		/* UARTA2Mf[^EWX^ */
#define	UA2TX		0xFFFFFA27		/* UARTA2Mf[^EWX^ */
#define	INTF0		0xFFFFFC00		/* O荞ݗGbWw背WX^0 */
#define	INTF3		0xFFFFFC06		/* O荞ݗGbWw背WX^3 */
#define	INTF9H		0xFFFFFC13		/* O荞ݗGbWw背WX^9H */
#define	INTR0		0xFFFFFC20		/* O荞ݗオGbWw背WX^0 */
#define	INTR3		0xFFFFFC26		/* O荞ݗオGbWw背WX^3 */
#define	INTR9H		0xFFFFFC33		/* O荞ݗオGbWw背WX^9H */
#define	PF0			0xFFFFFC60		/* |[g0t@NV䃌WX^ */
#define	PF3			0xFFFFFC66		/* |[g3t@NV䃌WX^ */
#define	PF3L		0xFFFFFC66		/* |[g3t@NV䃌WX^L */
#define	PF3H		0xFFFFFC67		/* |[g3t@NV䃌WX^H */
#define	PF4			0xFFFFFC68		/* |[g4t@NV䃌WX^ */
#define	PF5			0xFFFFFC6A		/* |[g5t@NV䃌WX^ */
#define	PF9			0xFFFFFC72		/* |[g9t@NV䃌WX^ */
#define	PF9L		0xFFFFFC72		/* |[g9t@NV䃌WX^L */
#define	PF9H		0xFFFFFC73		/* |[g9t@NV䃌WX^H */
#define	CB0CTL0		0xFFFFFD00		/* CSIB0䃌WX^0 */
#define	CB0CTL1		0xFFFFFD01		/* CSIB0䃌WX^1 */
#define	CB0CTL2		0xFFFFFD02		/* CSIB0䃌WX^2 */
#define	CB0STR		0xFFFFFD03		/* CSIB0ԃWX^ */
#define	CB0RX		0xFFFFFD04		/* CSIB0Mf[^EWX^ */
#define	CB0RXL		0xFFFFFD04		/* CSIB0Mf[^EWX^L */
#define	CB0TX		0xFFFFFD06		/* CSIB0Mf[^EWX^ */
#define	CB0TXL		0xFFFFFD06		/* CSIB0Mf[^EWX^L */
#define	CB1CTL0		0xFFFFFD10		/* CSIB1䃌WX^0 */
#define	CB1CTL1		0xFFFFFD11		/* CSIB1䃌WX^1 */
#define	CB1CTL2		0xFFFFFD12		/* CSIB1䃌WX^2 */
#define	CB1STR		0xFFFFFD13		/* CSIB1ԃWX^ */
#define	CB1RX		0xFFFFFD14		/* CSIB1Mf[^EWX^ */
#define	CB1RXL		0xFFFFFD14		/* CSIB1Mf[^EWX^L */
#define	CB1TX		0xFFFFFD16		/* CSIB1Mf[^EWX^ */
#define	CB1TXL		0xFFFFFD16		/* CSIB1Mf[^EWX^L */
#define	CB2CTL0		0xFFFFFD20		/* CSIB2䃌WX^0 */
#define	CB2CTL1		0xFFFFFD21		/* CSIB2䃌WX^1 */
#define	CB2CTL2		0xFFFFFD22		/* CSIB2䃌WX^2 */
#define	CB2STR		0xFFFFFD23		/* CSIB2ԃWX^ */
#define	CB2RX		0xFFFFFD24		/* CSIB2Mf[^EWX^ */
#define	CB2RXL		0xFFFFFD24		/* CSIB2Mf[^EWX^L */
#define	CB2TX		0xFFFFFD26		/* CSIB2Mf[^EWX^ */
#define	CB2TXL		0xFFFFFD26		/* CSIB2Mf[^EWX^L */
#define	CB3CTL0		0xFFFFFD30		/* CSIB3䃌WX^0 */
#define	CB3CTL1		0xFFFFFD31		/* CSIB3䃌WX^1 */
#define	CB3CTL2		0xFFFFFD32		/* CSIB3䃌WX^2 */
#define	CB3STR		0xFFFFFD33		/* CSIB3ԃWX^ */
#define	CB3RX		0xFFFFFD34		/* CSIB3Mf[^EWX^ */
#define	CB3RXL		0xFFFFFD34		/* CSIB3Mf[^EWX^L */
#define	CB3TX		0xFFFFFD36		/* CSIB3Mf[^EWX^ */
#define	CB3TXL		0xFFFFFD36		/* CSIB3Mf[^EWX^L */
#define	CB4CTL0		0xFFFFFD40		/* CSIB4䃌WX^0 */
#define	CB4CTL1		0xFFFFFD41		/* CSIB4䃌WX^1 */
#define	CB4CTL2		0xFFFFFD42		/* CSIB4䃌WX^2 */
#define	CB4STR		0xFFFFFD43		/* CSIB4ԃWX^ */
#define	CB4RX		0xFFFFFD44		/* CSIB4Mf[^EWX^ */
#define	CB4RXL		0xFFFFFD44		/* CSIB4Mf[^EWX^L */
#define	CB4TX		0xFFFFFD46		/* CSIB4Mf[^EWX^ */
#define	CB4TXL		0xFFFFFD46		/* CSIB4Mf[^EWX^L */
#define	IIC0		0xFFFFFD80		/* IICVtgEWX^0 */
#define	IICC0		0xFFFFFD82		/* IICRg[EWX^0 */
#define	SVA0		0xFFFFFD83		/* X[uEAhXEWX^0 */
#define	IICCL0		0xFFFFFD84		/* IICNbNIWX^0 */
#define	IICX0		0xFFFFFD85		/* IIC@\gWX^0 */
#define	IICS0		0xFFFFFD86		/* IICԃWX^0 */
#define	IICF0		0xFFFFFD8A		/* IICtOEWX^0 */
#define	IIC1		0xFFFFFD90		/* IICVtgEWX^1 */
#define	IICC1		0xFFFFFD92		/* IICRg[EWX^1 */
#define	SVA1		0xFFFFFD93		/* IICX[uEAhXEWX^1 */
#define	IICCL1		0xFFFFFD94		/* IICNbNIWX^1 */
#define	IICX1		0xFFFFFD95		/* IIC@\gWX^1 */
#define	IICS1		0xFFFFFD96		/* IICԃWX^1 */
#define	IICF1		0xFFFFFD9A		/* IICtOEWX^1 */
#define	IIC2		0xFFFFFDA0		/* IICVtgEWX^2 */
#define	IICC2		0xFFFFFDA2		/* IICRg[EWX^2 */
#define	SVA2		0xFFFFFDA3		/* IICX[uEAhXEWX^2 */
#define	IICCL2		0xFFFFFDA4		/* IICNbNIWX^2 */
#define	IICX2		0xFFFFFDA5		/* IIC@\gWX^2 */
#define	IICS2		0xFFFFFDA6		/* IICԃWX^2 */
#define	IICF2		0xFFFFFDAA		/* IICtOEWX^2 */
#define	EXIMC		0xFFFFFFBE		/* OoXEC^tF[XE[hERg[EWX^ */

#endif	/* _V850ES_SG2_H_ */
