/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005 by Freelines CO.,Ltd 
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_support.S,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *	^[QbgVXeˑW[ AZuꕔiTK-850ES/KJ1+pj
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "v850asm.inc"

#define Set(x,y,z) Lea x, r6; Lea y, r7; st.##z r7, 0[r6]

/*
 *  ჌x̃^[QbgVXeˑ̏
 *
 *  X^[gAbvW[̒ŁC̏̑OɌĂяoD
 */

	.text
	.globl hardware_init_hook
hardware_init_hook:

	/* VXeEFCgRg[WX^F5MHz~4=20MHz */
	Set(VSWC,  0x01,   b)
	/* ی삳ꂽ背WX^ւ̃ANZX
	   vZbTNbNRg[WX^FCNbNfxxo(PCC=0) */
	lea	PRCMD, r6
	lea	PCC, r7
	st.b	r0, 0[r6]
	st.b	r0, 0[r7]
	nop
	nop
	nop
	nop
	nop
	Set(PLLCTL,0x03,   h)   /* PLLRg[WX^FPLL */
	Set(WDTM2, 0x07,   b)   /* WDTM2 stop */
#if 0
	/* OoX̐ݒF
	     CS0ɊOSRAM𑝐݂ꍇ̎QlBł̓oX̓Zp[goXŁA
	     12nsiSRAM0waitœ삷邱Ƃ肵ݒB
	 */
	Set(EXIMC, 0x01,   b)	/* OoXC^[tFCX[hWX^FZp[goX */
	Set(PMC9,  0xFFFF, h)	/* P9[hRg[WX^FA0-A15o */
	Set(PMCCS, 0x01,   b)	/* PCS[hRg[WX^FC0o */
	Set(PMCCT, 0x53,   b)	/* PCT[hRg[WX^FRD/WR/ASTBo */
	Set(PMCDH, 0xFF,   b)	/* PDH[hRg[WX^FA16-A23o */
	Set(PMCDL, 0xFFFF, h)	/* PDL[hRg[WX^FAD0-AD15o */
	Set(DWC0,  0x7770, h)	/* f[^EFCg䃌WX^FCS0wait=0 */
	Set(AWC,   0xFFFC, h)	/* AhXEFCg䃌WX^FCS0wait=0 */
	Set(BCC,   0xAAA8, h)	/* oXTCN䃌WX^FCS0wait=0 */
#endif

	jmp		r31



	/* WݏƃX؁[T[ */
	.macro StandardInterruptEntry name
	.globl \name
\name:
	jr	vector_handler
	nop;nop;nop;nop;nop;nop
	.endm

	.macro ReservedInterruptEntry
	nop;nop;nop;nop;nop;nop;nop;nop
	.endm

/*
 * ݃nh̒`
 * 		Ƃ肠ӏɏW߂B
 */

	.section	".vectors","ax"
	.align      4
	.globl      __reset
__reset:
	jr	start
	nop;nop;nop;nop;nop;nop

	StandardInterruptEntry NMI
	StandardInterruptEntry INTWDT1
	StandardInterruptEntry INTWDT2
	StandardInterruptEntry TRAP0
	StandardInterruptEntry TRAP1
	StandardInterruptEntry DBG
/*#-------------------------------------------------------------------
  #	SECURITY_ID
  #-------------------------------------------------------------------*/
/*	.section	"SECURITY_ID" */
	.word	0xffffffff	/* --0-3 byte code,Address is 0x70-0x73 */
	.word	0xffffffff	/* --4-7 byte code,Address is 0x74-0x77 */
	.hword	0xffff		/* --8-9 byte code,Address is 0x78-0x79 */
/*#-------------------------------------------------------------------
  #	OPTION_BYTES
  #-------------------------------------------------------------------*/
/*	.section	"OPTION_BYTES" */
	.hword	0x0000		/* --0-1 byte code,Address is 0x7a-0x7b */
	.hword	0x0000		/* --2-3 byte code,Address is 0x7c-0x7d */
	.hword	0x0000		/* --4-5 byte code,Address is 0x7e-0x7f */

	StandardInterruptEntry INTWDTM1
	StandardInterruptEntry INTP0
	StandardInterruptEntry INTP1
	StandardInterruptEntry INTP2
	StandardInterruptEntry INTP3
	StandardInterruptEntry INTP4
	StandardInterruptEntry INTP5
	StandardInterruptEntry INTP6
	StandardInterruptEntry INTTM000
	StandardInterruptEntry INTTM001
	StandardInterruptEntry INTTM010
	StandardInterruptEntry INTTM011
	StandardInterruptEntry INTTM50
	StandardInterruptEntry INTTM51
	StandardInterruptEntry INTCSI00
	StandardInterruptEntry INTCSI01
	StandardInterruptEntry INTSRE0
	StandardInterruptEntry INTSR0
	StandardInterruptEntry INTST0
	StandardInterruptEntry INTSRE1
	StandardInterruptEntry INTSR1
	StandardInterruptEntry INTST1
	StandardInterruptEntry INTTMH0
	StandardInterruptEntry INTTMH1
	StandardInterruptEntry INTCSIA0
	StandardInterruptEntry INTIIC0
	StandardInterruptEntry INTAD
	StandardInterruptEntry INTKR
	StandardInterruptEntry INTWTI
	StandardInterruptEntry INTWT
	StandardInterruptEntry INTBRG
	StandardInterruptEntry INTTM020
	StandardInterruptEntry INTTM021
	StandardInterruptEntry INTTM030
	StandardInterruptEntry INTTM031
	StandardInterruptEntry INTCSIA1
	StandardInterruptEntry INTTM040
	StandardInterruptEntry INTTM041
	StandardInterruptEntry INTTM050
	StandardInterruptEntry INTTM051
	StandardInterruptEntry INTCSI02
	StandardInterruptEntry INTSRE2
	StandardInterruptEntry INTSR2
	StandardInterruptEntry INTST2
	StandardInterruptEntry INTIIC1
	ReservedInterruptEntry 
	ReservedInterruptEntry 
	ReservedInterruptEntry 
	ReservedInterruptEntry 
	ReservedInterruptEntry 
	StandardInterruptEntry INTTP0OV
	StandardInterruptEntry INTTP0CC0
	StandardInterruptEntry INTTP0CC1

/*
 * ]p\?^C}
 *  (͕]pt[jO^C}炸ɒڃ^C}JE^̂)
 */
Function _vxget_tim
	Lea	TM00, r7
	ld.h	0[r7], r8
	st.w	r8, 0[r6]
	mov	r0, r10
	jmp	r31
