/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                     2003 by Advanced Data Controls, Corp
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_config.c,v 1.1 2008/06/17 00:04:58 suikan Exp $
 */

/*
 * ^[QbgVXeˑW[iSolution Enginepj
 */

#include "jsp_kernel.h"
#include <sil.h>
#include <solution_engine.h>
#include <fdc37c935a.h>

/*
 *  ^[QbgVXeˑ [`
 */
void
sys_initialize()
{
#if defined(MS7709ASE01) || defined(MS7729RSE01)    
    /* Enable IRL Interrupt */
    sil_wrh_mem((VP)ICR1, 0x5000);
#else /* MS7750SE01 */
    sil_wrh_mem((VP)ICR, 0x0000);
#endif /* defined(MS7709ASE01) | defined(MS7729RSE01) */   
    /*
     * Init Super I/O
     */
    smsc_init();

    /*
     * Init SIO
     */
    fdc37c935a_init();
}


/*
 *  ^[QbgVXȅI[`
 *
 *  VXeI鎞ɎgDʏ̓j^ĂяoŎD
 *  
 */
void
sys_exit(void)
{
  kernel_abort();
}

/*
 *   VXeo͐̎w
 */

#ifdef  MULTI_IO
#include <stdio.h>
#define SYS_PUT_CHAR(c) putchar(c)
#else
#define SYS_PUT_CHAR(c) fdc37c935a_pol_putc(c)
#endif 

void
sys_putc(char c)
{
    if (c == '\n') {
        SYS_PUT_CHAR('\r');
    }
    SYS_PUT_CHAR(c);
}



