/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sh7615scif.c,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

/*
 *   SH2VAR~jP[VC^tF[XSCIFp ȈՃhCo
 */

#include <s_services.h>
#include "sh7615scif.h"

/*
 *  VAI/O|[gǗubN̒`
 */
/* o̓|[g̐ݒsys_config.c */
/* ݃xN^ԍ̐ݒhw_serial.h */
/* ǗubN̐ݒsh7615scif.c */

#ifndef GDB_STUB

const SIOPINIB siopinib_table[TNUM_PORT] = {
	{0xfffffcc0, BRR9600, 0x0, 6}, /* SCIF1 */
#if TNUM_PORT >= 2
	{0xfffffce0, BRR9600, 0x0, 6}, /* SCIF2 */
#endif /* TNUM_PORT >= 2 */
};

#else /* GDB_STUB */

const SIOPINIB siopinib_table[TNUM_PORT] = {
	{0xfffffce0, BRR9600, 0x0, 6}, /* SCIF2 */
};

#endif /* GDB_STUB */

#if defined(TTM)
/*
 *  VAI/O|[gǗubN̒`
 *  @2chT|[gɊgꍇ͏lp̃f[^܂߂
 */
struct sio_port_control_block
{
	VP_INT exinf;				/* g */
	BOOL openflag;				/* I[vς݃tO */
};
#endif
/*
 *  VAI/O|[gǗubÑGA
 */
static SIOPCB siopcb_table[TNUM_PORT];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  Mł邩H
 */
Inline BOOL
sh2scif_getready (SIOPCB * siopcb)
{
	/*  V[uf[^WX^tEtÕ`FbN  */
	return (sil_reh_mem ((VH *) (siopcb->siopinib->reg_base + SCIF_SC1SSR)) &
			SC1SSR_RDRF);
}

/*
 *  𑗐Mł邩H
 */
Inline BOOL
sh2scif_putready (SIOPCB * siopcb)
{
	/*  gX~bgFIFOf[^WX^GveBEtÕ`FbN */
	return (sil_reh_mem ((VH *) (siopcb->siopinib->reg_base + SCIF_SC1SSR)) &
			SC1SSR_TDFE);
}

/*
 *  M̎o
 */
Inline char
sh2scif_getchar (SIOPCB * siopcb)
{
	VB data;

	data = sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCFRDR));
	/*  V[uf[^WX^tEtÕNA  */
	sil_wrh_mem ((VH *) (siopcb->siopinib->reg_base + SCIF_SC1SSR),
				 sil_reh_mem ((VH *) (siopcb->siopinib->reg_base +
									  SCIF_SC1SSR)) & ~SC1SSR_RDRF);
	return data;
}

/*
 *  M镶̏
 */
Inline void
sh2scif_putchar (SIOPCB * siopcb, char c)
{
	/*  gX~bgFIFOf[^WX^GveBEtÕNA */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCFTDR), c);
	sil_wrh_mem ((VH *) (siopcb->siopinib->reg_base + SCIF_SC1SSR),
				 sil_reh_mem ((VH *) (siopcb->siopinib->reg_base +
									  SCIF_SC1SSR)) & ~SC1SSR_TDFE);
}

/*
 *  SIOhCȍ[`
 */
void
sh2scif_initialize ()
{
	SIOPCB *siopcb;
	UINT i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_PORT; siopcb++, i++) {
		siopcb->openflag = FALSE;
		siopcb->siopinib = (&siopinib_table[i]);
	}
}

/*
 *  I[vĂ|[g邩H
 */
BOOL
sh2scif_openflag (ID siopid)
{
	return (siopcb_table[siopid - 1].openflag);
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
sh2scif_opn_por (ID siopid, VP_INT exinf)
{
	SIOPCB *siopcb;

	siopcb = get_siopcb (siopid);

	/*  M~  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR),
				 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
									  SCIF_SCSCR)) & ~(SCSCR_TE | SCSCR_RE));

	/*  SCIf[^o̓|[g̐ݒ  */
	/*  sATC */
	/* sys_initializeŐݒ */

	/*  FIFȌ  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCFCR),
				 (VB) (SCFCR_TFRST | SCFCR_RFRST));

	/*  MtH[}bg  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSMR), 0x00);
	/*    */
	/*  8rbgApeBȂ  */
	/*  XgbvrbgOXF1   */
	/*  NbNZNg */

	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCBRR), (VB) siopcb->siopinib->brr);	/* {[[gݒ */


	/*
	 * {[[g̐ݒA1JEg҂Ȃ΂ȂȂB
	 */
	sil_dly_nse (sh2scif_DELAY);	/* l͂PƓ */

	/*  FIFO̐ݒ  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCFCR), 0x00);

	/* G[tONA */
	sil_wrh_mem ((VH *) (siopcb->siopinib->reg_base + SCIF_SC1SSR),
				 sil_reh_mem ((VH *) (siopcb->siopinib->reg_base +
									  SCIF_SC1SSR)) & ~SC1SSR_ER);

	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR),
				 (VB) (SCSCR_RIE | SCSCR_TE | SCSCR_RE));

	siopcb->exinf = exinf;
	siopcb->openflag = TRUE;
	return (siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
sh2scif_cls_por (SIOPCB * siopcb)
{
	/*  M~A݋֎~  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR),
				 (VB) ~ (SCSCR_TIE | SCSCR_RIE | SCSCR_TE | SCSCR_RE));

	siopcb->openflag = FALSE;
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
sh2scif_snd_chr (SIOPCB * siopcb, char c)
{
	if (sh2scif_putready (siopcb)) {
		sh2scif_putchar (siopcb, c);
		return (TRUE);
	}
	return (FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
sh2scif_rcv_chr (SIOPCB * siopcb)
{
	if (sh2scif_getready (siopcb)) {
		return ((INT) (UB) sh2scif_getchar (siopcb));
	}
	return (-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
sh2scif_ena_cbr (SIOPCB * siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:			/* M荞ݗv */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCIF_SCSCR)) | SCSCR_TIE);
		break;
	case SIO_ERDY_RCV:			/* M荞ݗv */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCIF_SCSCR)) | SCSCR_RIE);
		break;
	}
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
sh2scif_dis_cbr (SIOPCB * siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:			/* M荞ݗv֎~ */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCIF_SCSCR)) & ~SCSCR_TIE);
		break;
	case SIO_ERDY_RCV:			/* M荞ݗv֎~ */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCIF_SCSCR)) & ~SCSCR_RIE);
		break;
	}
}

/*
 *  VAI/O|[gɑ΂鑗Mݏ
 */
Inline void
sh2scif_isr_siop_out (SIOPCB * siopcb)
{
	VB scr0 = sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR));

	if ((scr0 & SCSCR_TIE) != 0 && sh2scif_putready (siopcb)) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		sh2scif_ierdy_snd (siopcb->exinf);
	}
}

/*
 *  VAI/O|[gɑ΂Mݏ
 */
Inline void
sh2scif_isr_siop_in (SIOPCB * siopcb)
{
	VB scr0 = sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR));

	if ((scr0 & SCSCR_RIE) != 0 && sh2scif_getready (siopcb)) {
		/*
		 *  MʒmR[obN[`ĂяoD
		 */
		sh2scif_ierdy_rcv (siopcb->exinf);
	}
}

/*
 *  VAI/O|[gɑ΂MG[ݏ
 */
Inline void
sh2scif_isr_siop_err (SIOPCB * siopcb)
{
	/* G[tONA */
	sil_wrh_mem ((VH *) (siopcb->siopinib->reg_base + SCIF_SC1SSR),
				 sil_reh_mem ((VH *) (siopcb->siopinib->reg_base +
									  SCIF_SC1SSR)) & ~SC1SSR_ER);
	/*  FIFȌ  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCFCR),
				 (VB) SCFCR_RFRST);
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCFCR), 0x30);
}

/* u[No */
/* tOZbg */
Inline void
sh2scif_isr_siop_brk (SIOPCB * siopcb)
{
	/* tONA */
	sil_wrh_mem ((VH *) (siopcb->siopinib->reg_base + SCIF_SC1SSR),
				 sil_reh_mem ((VH *) (siopcb->siopinib->reg_base +
									  SCIF_SC1SSR)) & ~SC1SSR_BRK);
}

/*
 *  SCIM݃T[rX[` PƓ
 *  
 *  @SH1SCIł͊ݔԍMʁA`lʂɕĂ̂ŁA
 *  @SCI0̑M݈ȊOł̃[`Ă΂邱Ƃ͂Ȃ
 *  
 */
void
sh2scif_isr_out ()
{
	if (siopcb_table[0].openflag) {
		sh2scif_isr_siop_out (get_siopcb (1));
	}
}

/*
 *  SCIM݃T[rX[`@PƓ
 *  
 *  @SH1SCIł͊ݔԍMʁA`lʂɕĂ̂ŁA
 *  @SCI0̎M݈ȊOł̃[`Ă΂邱Ƃ͂Ȃ
 *  
 */
void
sh2scif_isr_in ()
{
	if (siopcb_table[0].openflag) {
		sh2scif_isr_siop_in (get_siopcb (1));
	}
}

/*
 *  SIOMG[݃T[rX[`@PƓ
 *  
 *  @SH1SCIł͊ݔԍ`lʂɕĂ̂ŁA
 *  @SCI0̎MG[݈ȊOł̃[`Ă΂邱Ƃ͂Ȃ
 *  @
 *  @G[̂̓G[tÕNÂ݂ɂƂǂ߂ĂB
 *  @@@EI[o[G[
 *  @@@Et[~OG[
 *  @@@EpeBG[
 */
void
sh2scif_isr_error (void)
{

	if (siopcb_table[0].openflag) {
		sh2scif_isr_siop_err (get_siopcb (1));
	}
}

/* u[No */
void
sh2scif_isr_brk (void)
{

	if (siopcb_table[0].openflag) {
		sh2scif_isr_siop_brk (get_siopcb (1));
	}
}

/*
 * |[Oɂ镶̑M
 */
void
sh2scif_putc_pol (ID portid, char c)
{
	while (!sh2scif_putready (&siopcb_table[portid - 1]));
	sh2scif_putchar (&siopcb_table[portid - 1], c);
}

#if TNUM_PORT >= 2
/*
 *  SCIM݃T[rX[`
 *  
 */
void
sh2scif_isr2_in (void)
{
	if (siopcb_table[1].openflag) {
		sh2scif_isr_siop_in (get_siopcb (2));
	}
}

/*
 *  SCIM݃T[rX[`
 *  
 */
void
sh2scif_isr2_out (void)
{
	if (siopcb_table[1].openflag) {
		sh2scif_isr_siop_out (get_siopcb (2));
	}
}

/*
 *  SCIMG[݃T[rX[`
 */
void
sh2scif_isr2_error (void)
{
	if (siopcb_table[1].openflag) {
		sh2scif_isr_siop_err (get_siopcb (2));
	}
}

/* u[No */
void
sh2scif_isr2_brk (void)
{

	if (siopcb_table[1].openflag) {
		sh2scif_isr_siop_brk (get_siopcb (2));
	}
}
#endif /* of #if TNUM_PORT >= 2 */
