/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000,2001 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *
 *  L쌠҂́CFree Software Foundation ɂČ\Ă
 *  GNU General Public License  Version 2 ɋLqĂC
 *  ̏̂ꂩ𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *  @(#) $Id: sh7615.h,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

#ifndef _SH7615_H_
#define _SH7615_H_

#include <sil.h>

/*
 *  ݂̃xN^ԍ`
 */
#define GII	 4					/*  ʕs:General Illegal Instruction  */
#define SII	 6					/*  Xbgs:Slot Illegal Instruction */
#define CAE	 9					/*  CPUAhXG[:CPU Address Error       */
#define DAE	10					/*  DMAAhXG[:DMA Address Error       */

#define NMI	11					/*  NMI         */
#define USBK	12				/*  [U[u[N    */
#define HUDI	13				/*  [U[fobOC^[tF[X    */
/* OxN^ԍw肷ꍇAĒ`ʂɒ` */
#define IRQ0	64				/*  Oݗv      */
#define IRQ1	65
#define IRQ2	66
#define IRQ3	67
#define IRL1	64
#define IRL2	65
#define IRL3	65
#define IRL4	66
#define IRL5	66
#define IRL6	67
#define IRL7	67
#define IRL8	68
#define IRL9	68
#define IRL10	69
#define IRL11	69
#define IRL12	70
#define IRL13	70
#define IRL14	71
#define IRL15	71

/* xN^ԍRɎw肷ꍇAĒ`ʂɒ` */
	/*  DMAC:_CNgANZXRg[  */
#define DMAC0	72				/*  DMAC0  */
#define DMAC1	73				/*  DMAC1  */

#define ITI	74					/*  WDT:EHb`hbN^C}        */
#define CMI	75					/*  REF:DRAMtbV        */
#define EINT	76				/*  EINT:EtherC荞         */

	/*  FRT:t[jO^C}  */
#define ICI	77					/*  FRT  */
#define OCI	78
#define OVI	79

	/*  TPU:^C}pXjbg  */
#define TGI0A	80				/*  TPU0  */
#define TGI0B	81
#define TGI0C	82
#define TGI0D	83
#define TCI0V	84
#define TGI1A	85				/*  TPU1  */
#define TGI1B	86
#define TCI1V	87
#define TCI1U	88
#define TGI2A	89				/*  TPU2  */
#define TGI2B	90
#define TCI2V	91
#define TCI2U	92

	/*  SCIF:VAR~jP[VC^[tF[X  */
#define ERI1	93				/*  SCI1  */
#define RXI1	94
#define BRI1	95
#define TXI1	96
#define ERI2	97				/*  SCI2  */
#define RXI2	98
#define BRI2	99
#define TXI2	100

	/*  SIO:VAI/O  */
#define EREI0	101				/*  SCI0  */
#define TERI0	102
#define RDFI0	103
#define TDEI0	104
#define EREI1	105				/*  SCI1  */
#define TERI1	106
#define RDFI1	107
#define TDEI1	108
#define EREI2	109				/*  SCI2  */
#define TERI2	110
#define RDFI2	111
#define TDEI2	112



#ifndef _MACRO_ONLY

/*
 *  SH2̓WX^`
 */

/* WX^̃ANZX͌32bit */
/*
 *   oXXe[gRg[
 */
/* oXRg[WX^ */
#define BCR1    ((VW *)0xffffffe0)
#define BCR2    ((VW *)0xffffffe4)
#define BCR3    ((VW *)0xfffffffc)
/* EFCgRg[WX^ */
#define WCR1    ((VW *)0xffffffe8)
#define WCR2    ((VW *)0xffffffc0)
#define WCR3    ((VW *)0xffffffc4)
/* ʃRg[WX^ */
#define MCR     ((VW *)0xffffffec)
/* tbV^C}Rg[/Xe[^XWX^ */
#define RTCSR   ((VW *)0xfffffff0)
/* tbV^C}JE^ */
#define RTCNT   ((VW *)0xfffffff4)
/* tbV^CRX^gWX^ */
#define RTCOR   ((VW *)0xfffffff8)
/*-----UH-----*/
#define FMR     ((VB *)0xfffffe90)

/*
 * st@NVRg[
 */
#define PACR    ((VH *)0xfffffc80)	/*  |[gA Rg[WX^  */
#define PAIOR   ((VH *)0xfffffc82)	/*  |[gA I/OWX^       */
#define PBCR    ((VH *)0xfffffc88)	/*  |[gB Rg[WX^  */
#define PBIOR   ((VH *)0xfffffc8a)	/*  |[gB I/OWX^       */
#define PBCR2   ((VH *)0xfffffc8e)	/*  |[gB Rg[WX^2 */
#define PADR    ((VH *)0xfffffc84)	/*  |[gA f[^WX^        */
#define PBDR    ((VH *)0xfffffc8c)	/*  |[gB f[^WX^        */

/* 荞ݗDxxݒ背WX^ */
#define IPRA    ((VH *)0xfffffee2)
#define IPRB    ((VH *)0xfffffe60)
#define IPRC    ((VH *)0xfffffee6)
#define IPRD    ((VH *)0xfffffe40)
#define IPRE    ((VH *)0xfffffec0)
/* xN^ԍݒ背WX^ */
#define VCRA    ((VH *)0xfffffe62)
#define VCRB    ((VH *)0xfffffe64)
#define VCRC    ((VH *)0xfffffe66)
#define VCRD    ((VH *)0xfffffe68)
#define VCRE    ((VH *)0xfffffe42)
#define VCRF    ((VH *)0xfffffe44)
#define VCRG    ((VH *)0xfffffe46)
#define VCRH    ((VH *)0xfffffe48)
#define VCRI    ((VH *)0xfffffe4a)
#define VCRJ    ((VH *)0xfffffe4c)
#define VCRK    ((VH *)0xfffffe4e)
#define VCRL    ((VH *)0xfffffe50)
#define VCRM    ((VH *)0xfffffe52)
#define VCRN    ((VH *)0xfffffe54)
#define VCRO    ((VH *)0xfffffe56)
#define VCRP    ((VH *)0xfffffec2)
#define VCRQ    ((VH *)0xfffffec4)
#define VCRR    ((VH *)0xfffffec6)
#define VCRS    ((VH *)0xfffffec8)
#define VCRT    ((VH *)0xfffffeca)
#define VCRU    ((VH *)0xfffffecc)
#define VCRWDT  ((VH *)0xfffffee4)
#define DMA_VCRDMA0     ((VW *)0xffffffa0)
#define DMA_VCRDMA1     ((VW *)0xffffffa8)
/* 荞݃Rg[WX^ */
#define ICR     ((VH *)0xfffffee0)
/* 荞݃Rg[/Xe[^XWX^ */
#define IRQCSR  ((VH *)0xfffffee8)

/*
 * 荞݃Rg[̏
 */
Inline void
sh2_init_intcontorller (void)
{
	sil_wrh_mem (IPRA, 0x0000);
	sil_wrh_mem (IPRB, 0x0000);
	sil_wrh_mem (IPRC, 0x0000);
	sil_wrh_mem (IPRD, 0x0000);
	sil_wrh_mem (IPRE, 0x0000);
}

#endif /* _MACRO_ONLY */

#endif /* _SH7615_H_ */
