/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sh7145sci.h,v 1.1 2008/06/17 00:04:40 suikan Exp $
 */

/*
 *   SH2VAR~jP[VC^tF[XSCIp ȈՃhCo
 */

#ifndef _sh7145sci_H_
#define _sh7145sci_H_

#include <t_config.h>

/*
 *  VAI/O|[gubN
 */
typedef struct sio_port_initialization_block
{
	UW reg_base;				/* WX^̃x[XAhX */
	UB brr;						/* {[[g̐ݒl   */
	UB smr;						/* [hWX^̐ݒl   */
	UB int_level;				/* 荞݃x̐ݒl   */
} SIOPINIB;

/*
 *  VAI/O|[gǗubN
 */
typedef struct sio_port_control_block
{
	const SIOPINIB *siopinib;	/* VAI/O|[gubN */
	VP_INT exinf;				/* g */
	BOOL openflag;				/* I[vς݃tO */
	BOOL sendflag;				/* M݃Cl[utO */
	BOOL getready;				/* M */
	BOOL putready;				/* 𑗐Mł */
} SIOPCB;

/*
 *  Rg[WX^̃AhX̃ItZbg 
 */
#define SCI_SCR	0x2
#define SCI_SSR	0x4
#define SCI_BRR	0x1
#define SCI_SMR	0x0
#define SCI_TDR	0x3
#define SCI_RDR	0x5
#define SCI_SDCR 0x6


/*
 *  Rg[WX^̐ݒl
 */
#define SCI_TIE		0x80		/* gX~bgC^vgCl[u */
#define SCI_RIE		0x40		/* V[uC^vgCl[u   */
#define SCI_TE		0x20		/* gX~bgCl[u         */
#define SCI_RE		0x10		/* V[uCl[u           */
#define SSR_ORER	0x20		/* I[o[G[           */
#define SSR_FER		0x10		/* t[~OG[           */
#define SSR_PER		0x08		/* peBG[           */
#define SSR_TDRE	0x80		/* gX~bgf[^WX^GveB */
#define SSR_RDRF	0x40		/* V[uf[^WX^t       */

#define sh2sci_DELAY 	105000

#define PFC_TXD0	0x0004
#define PFC_RXD0	0x0001
#define PFC_TXD1	0x0100
#define PFC_RXD1	0x0040
#define PFC_TXD2	0x0020
#define PFC_RXD2	0x8000

/*
 *  SCI̐ݒ
 */
#define SMR_CKS 	0x0			/*            */
#define BRR9600 	79			/*  9600 rbg[g    */
#define BRR19200	39			/*  19200 rbg[g    */
#define BRR38400	19			/*  38400 rbg[g    */

/*
 *  R[obN[`̎ʔԍ
 */
#define SIO_ERDY_SND	1u		/* M\R[obN */
#define SIO_ERDY_RCV	2u		/* MʒmR[obN */

/*
 *  SIOhCȍ[`
 */
extern void sh2sci_initialize (void);

/*
 *  I[vĂ|[g邩H
 */
extern BOOL sh2sci_openflag (ID siopid);

/*
 *  VAI/O|[g̃I[v
 */
extern SIOPCB *sh2sci_opn_por (ID siopid, VP_INT exinf);

/*
 *  VAI/O|[g̃N[Y
 */
extern void sh2sci_cls_por (SIOPCB * siopcb);

/*
 *  VAI/O|[gւ̕M
 */
extern BOOL sh2sci_snd_chr (SIOPCB * siopcb, char c);

/*
 *  VAI/O|[g̕M
 */
extern INT sh2sci_rcv_chr (SIOPCB * siopcb);

/*
 *  VAI/O|[g̃R[obN̋
 */
extern void sh2sci_ena_cbr (SIOPCB * siopcb, UINT cbrtn);

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void sh2sci_dis_cbr (SIOPCB * siopcb, UINT cbrtn);

/*
 *  SIO̊݃T[rX[`
 */
extern void sh2sci_isr (void);

/*
 *  VAI/O|[g̑M\R[obN
 */
extern void sh2sci_ierdy_snd (VP_INT exinf);

/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void sh2sci_ierdy_rcv (VP_INT exinf);

#endif /* _sh7145sci_H_ */
