/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_config.c,v 1.1 2008/06/17 00:04:43 suikan Exp $
 */

#include "jsp_kernel.h"
#include <sil.h>
#include <s_services.h>
#include "sh7145sci.h"

/*
 *  ^[QbgVXeˑ̏
 */
/*
 *  VAI/O|[g̏ bannero͂̂߃J[l̏Ɩ֌Wɍs
 */
void
sys_initialize ()
{
	SIOPCB *siopcb;

	/* gpӋ@͂ŗLɂĂB */
	/*  SCIf[^o̓|[g̐ݒ  */

#ifndef GDB_STUB

	/* SCI1 */
	sil_wrh_mem (MSTCR1, (VH) ((VH) sil_reh_mem (MSTCR1) & ~0x0002));
	sil_wrh_mem (PACRL2, sil_reh_mem (PACRL2) | (PFC_TXD1 | PFC_RXD1));
#if TNUM_PORT >=2
	/* SCI0 */
	sil_wrh_mem (MSTCR1, (VH) ((VH) sil_reh_mem (MSTCR1) & ~0x0001));
	sil_wrh_mem (PACRL2, sil_reh_mem (PACRL2) | (PFC_TXD0 | PFC_RXD0));
#endif /*TNUM_PORT >=2 */

#else /* GDB_STUB */

	/* SCI0 */
	sil_wrh_mem (MSTCR1, (VH) ((VH) sil_reh_mem (MSTCR1) & ~0x0001));
	sil_wrh_mem (PACRL2, sil_reh_mem (PACRL2) | (PFC_TXD0 | PFC_RXD0));

#endif /* GDB_STUB */

	/* CMT0 */
	sil_wrh_mem (MSTCR2, (VH) ((VH) sil_reh_mem (MSTCR2) & ~0x1000));
	/*
	 *  foCXˑ̃I[vD
	 */
	/*oi[o͂邽 */
	sh2sci_initialize();
	siopcb = sh2sci_opn_por (LOGTASK_PORTID, 0);
}

/*
 *  ^[QbgVXȅI
 */
void
sys_exit ()
{
	sh2_exit ();
}

/*
 *  ^[QbgVXe̕o
 */
void
sys_putc (char c)
{
	if (c == '\n') {
		sh2_putc (LOGTASK_PORTID, '\r');
	}
	sh2_putc (LOGTASK_PORTID, c);
}

/* n[hEFA̐ݒ */
/* ł̓oX̐ݒ̂ݍsBӋ@̐ݒsys_initializeōsB */
#ifndef GDB_STUB
void
hardware_init_hook (void)
{
	sil_wrh_mem (BCR1, 0x202f);
	sil_wrh_mem (BCR2, 0x5500);
	sil_wrh_mem (WCR1, 0x0010);
	sil_wrh_mem (PACRH, 0x5000);
	sil_wrh_mem (PACRL1, 0x1540);
	sil_wrh_mem (PACRL2, 0x0140);
	sil_wrh_mem (PBCR1, 0x0002);
	sil_wrh_mem (PBCR2, 0xa005);
	sil_wrh_mem (PCCR, 0xfffc);
	sil_wrh_mem (PDCRH1, 0x5555);
	sil_wrh_mem (PDCRH2, 0x5555);
	sil_wrh_mem (PDCRL1, 0xffff);
	sil_wrh_mem (PDCRL2, 0x0000);
	sil_wrh_mem (PECRL1, 0x0000);
	sil_wrh_mem (PECRL2, 0x0000);
	sil_wrh_mem (PAIORL, 0x87e7);
	sil_wrh_mem (PBIOR, 0x023c);
}
#else /*  GDB_STUB  */
void
hardware_init_hook (void)
{
}
#endif /*  GDB_STUB  */
