/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: apsh2f6a.h,v 1.1 2008/06/17 00:04:43 suikan Exp $
 */

/*
 *  {[hŗL̒`
 */

#ifndef _APSH2F6A_H_
#define _APSH2F6A_H_

/*
 *  GDB STUBďo[`
 */
#ifndef _MACRO_ONLY
#ifdef GDB_STUB

#define sh2_exit	gdb_stub_exit
#define sh2_putc	gdb_stub_putc

extern void sh2sci_putc_pol (ID portid, char c);	/*  sh7145sci.c  */

Inline void
gdb_stub_exit (void)
{
	/* eXgĂȂ */
	Asm ("trapa #0x20"::);
}

/*
 *  gdb stubɂo
 */
Inline int
gdb_stub_putc (ID portid, int c)
{
	sh2sci_putc_pol (portid, c);
	return (c);
}
#else /* GDB_STUB */
/*
 *  ROM̏ꍇ
 */

Inline void
sh2_exit ()
{
	while (1);
}

extern void sh2sci_putc_pol (ID portid, char c);	/*  sh7145sci.c  */
Inline void
sh2_putc (ID portid, char c)
{
	sh2sci_putc_pol (portid, c);
}
#endif /* GDB_STUB */
#endif /* _MACRO_ONLY */
#endif /* _APSH2F6A_H_ */
