/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by CHUO ELECTRIC WORKS Co.,LTD. JAPAN
 *
 *  L쌠҂́CFree Software Foundation ɂČ\Ă 
 *  GNU General Public License  Version 2 ɋLqĂC
 *  (1)`(4)̏𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */
 
#ifndef _DEVICE_H_
#define _DEVICE_H_

/*
 *  LED ID`
 */
#define LED1		1		/* LED1ID` */
#define LED2		2		/* LED2ID` */
#define LED3		3		/* LED3ID` */

/*
 *  LEDrbg
 */
#define LED_CTL1	0x0100		/* LED1  */
#define LED_CTL2	0x0040		/* LED2  */
#define LED_CTL3	0x1000		/* LED3  */

/*
 *  XCb`[hAhX
 */
#define SW_DR		((VB *)0x6000200)

/*
 *  fBbvXCb`擾p̃}XNrbg
 */
#define DSW11		0x10
#define DSW12		0x20
#define DSW13		0x40
#define DSW14		0x80

/*
 *  [^[XCb`擾p̃}XNrbg
 */
#define RSW_CTL		0x0F

/*
 *  ON OFF `
 */
#define ON		1
#define OFF		0

/*
 *  EIb`hbO^C}NA
 */
Inline void
wdt_clear(void)
{
	sil_wrh_mem(PA_DR, (sil_reh_mem(PA_DR) ^ (1<<5)));
}

/*
 *  foCX̃vg^Cv錾
 */
void	initial_led(void );
void	set_led( int led, int req );
int	get_led( int led );
int	get_dsw( int sw );
int	get_rsw( void );

#endif /* _DEVICE_H_ */
