/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sh1itu.h,v 1.1 2008/06/17 00:04:54 suikan Exp $
 */

/*
 *	^C}hCo
 *@@@@@SH1̃CeO[ebhE^C}EpXEjbgITU
 *@@@@@`l0gp
 */

#ifndef _SH1ITU_H_
#define _SH1ITU_H_

/*
 *  NbNgˑ̐ݒ
 *  
 *  @@NbNg̓RpCIvVŗ^
 */

/*
 *   ^C}ւ̓̓NbN̕ݒ
 *   	f/8ŃJEg
 */
#define TCR_TPSC	0x3u

/*
 *   ^C}ɋNbNg[kHz]
 *   	20MHz/8 =2.5MHz =2500kHz
 */
#ifdef CONFIG_20MHZ
#define TIMER_CLOCK	2500
#endif

/*
 *   	19.6608MHz/8 =2.4576MHz =2457.6kHz
 */
#ifdef CONFIG_19MHZ
#define TIMER_CLOCK	2458
#endif

/*
 *   	16MHz/8 =2MHz =2000kHz
 */
#ifdef CONFIG_16MHZ
#define TIMER_CLOCK	2000
#endif



/*
 *  ^C}l̓\̌^
 */
typedef UH	CLOCK;

/*
 *  ^C}l̓\ƃ~bEʕbPʂƂ̕ϊ
 *
 */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)
#define CLOCK_PER_TICK	((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ݒłő̃^C}iPʂ͓\j
 */
#define	MAX_CLOCK	((CLOCK) 0xffffu)

/*
 *  ^C}̌ݒlݔO̒lƂ݂Ȃ̔f
 */
#define	GET_TOLERANCE	100	/* x̌ςliPʂ͓\j*/
#define	BEFORE_IREQ(clock)  \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)


/*
 *  Rg[WX^̃AhX
 */

    	/*    */
#define ITU_TSTR (VB *)0x5ffff00 /*  ^C}X^[gWX^ i1oCgj*/
#define ITU_TSNC (VB *)0x5ffff01 /*  ^C}VNWX^ i1oCgj*/
#define ITU_TMDR (VB *)0x5ffff02 /*  ^C}[hWX^ i1oCgj  */
	/*  ^C}t@NVRg[WX^ i1oCgj */
#define ITU_TFCR (VB *)0x5ffff03 
	/*  ^C}AEgvbgRg[WX^ i1oCgj   */
#define ITU_TOCR (VB *)0x5ffff31

	/*  ITU0  */
#define ITU_TCR0  (VB *)0x5ffff04 /*  ^C}Rg[WX^0 i1oCgj*/
		/*  ^C}I/ORg[WX^0 i1oCgj*/
#define ITU_TIOR0 (VB *)0x5ffff05 
		/*  ^C}C^vgCl[uWX^0 i1oCgj*/
#define ITU_TIER0 (VB *)0x5ffff06 
#define ITU_TSR0  (VB *)0x5ffff07 /*  ^C}Xe[^XWX^0 i1oCgj*/
#define ITU_TCNT0 (VH *)0x5ffff08 /*  ^C}JE^0 i2oCgj*/
#define ITU_GRA0  (VH *)0x5ffff0a /*  WFlWX^A0 i2oCgj*/
#define ITU_GRB0  (VH *)0x5ffff0b /*  WFlWX^B0 i2oCgj*/


/*
 *  Rg[WX^̐ݒl
 */
#define TSR_IMFA	0x01u	/*  GRARyA}b`tO  		*/
#define TSTR_STR0	0x01u	/*  ^C}X^[grbg  		*/
#define TCR_CCLR_GRA	0x20u	/*  GRARyA}b`ŃJE^NA */
#define TIER_RESERVE	0x78u	/*  TIERWX^̗\rbg  		*/
#define TIER_IMIEA	0x01u	/*  GRARyA}b`ɂ銄ݗv */
#define TIOR_RESERVE	0x08u	/*  TIORWX^̗\rbg  		*/
#define TIOR_IOA	0x00u	/*  GRARyA}b`ɂ[qo͋֎~ */


#ifndef _MACRO_ONLY

/*
 *  ^C}X^[g
 */
Inline void
sh1_itu_start(void)
{
	sh1_orb_reg(ITU_TSTR, TSTR_STR0);
}

/*
 *  ^C}ꎞ~
 */
Inline void
sh1_itu_stop(void)
{
	sh1_anb_reg(ITU_TSTR, (VB)~TSTR_STR0);
}

/*
 *  ^C}ݗṽNA
 *	TCRWX^IMFArbg1ǂݏoɂO
 */
Inline void
sh1_itu_int_clear(void)
{
	/* 荞ݗvNA 	*/
	/*  iGRARyA}b`tOj */
	sh1_anb_reg(ITU_TSR0, (VB)~TSR_IMFA);
}


/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
sh1_itu_initialize(void)
{
	CLOCK	cyc = TO_CLOCK(TIC_NUME, TIC_DENO);


	/*
	 *  ^C}֘A̐ݒ
	 */
	sh1_itu_stop();		/* ^C}~ */
			     		/* ^C}l̃`FbN */
	assert(cyc <= MAX_CLOCK);
			/*  GRARyA}b`ŃJE^NA */
			/*  ݒ  			*/
	sil_wrb_mem(ITU_TCR0, TCR_CCLR_GRA | TCR_TPSC);
			/*  GRARyA}b`ɂ銄ݗv */
	sil_wrb_mem(ITU_TIER0, TIER_RESERVE | TIER_IMIEA);
			/*  GRARyA}b`ɂ[qo͋֎~ */
	sil_wrb_mem(ITU_TIOR0, TIOR_RESERVE | TIOR_IOA);
			/*  GRAWX^ݒiJE^ڕWlj  	*/
	sil_wrh_mem(ITU_GRA0, CLOCK_PER_TICK);
	sil_wrh_mem(ITU_TCNT0, 0);	/* JE^NA 	*/

}

/*
 *  ^C}̒~
 *
 *  ^C}̓~D
 */
Inline void
sh1_itu_terminate(void)
{
	sh1_itu_stop();			/* ^C}~ 	*/
	sh1_itu_int_clear();		/* 荞ݗvNA */

					/* ^C}݂֎~   */
			/*  iOVIE,IMIEB,IMIEArbgNAj  */
	sil_wrb_mem(ITU_TIER0, TIER_RESERVE);
}

/*
 *  ^C}̌ݒl̓Ǐo
 *@@@^C}̓ꎞIɒ~C^C}lǂݏoD
 */
Inline CLOCK
sh1_itu_get_current(void)
{
	CLOCK	clk;
	

	sh1_itu_stop();			/*  ^C}~  */
	
	/*  {͑҂Ԃׂ  */
	
	clk = sil_reh_mem(ITU_TCNT0);
	sh1_itu_start();			/*  ^C}X^[g  */
	
	return(clk);
}

/*
 *  ^C}ݗṽ`FbN
 */
Inline BOOL
sh1_itu_fetch_interrupt(void)
{
	VB tsr0 = sil_reb_mem(ITU_TSR0);
	return(tsr0 & TSR_IMFA);
}

#endif /* _MACRO_ONLY */
#endif /* _SH1ITU_H_ */
