/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by SEIKO EPSON Corp, JAPAN
 * 
 *  L쌠҂́CFree Software Foundation ɂČ\Ă 
 *  GNU General Public License  Version 2 ɋLqĂC
 *  (1)`(4)̏𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 */
OUTPUT_FORMAT("elf32-c33", "elf32-c33",
              "elf32-c33")
OUTPUT_ARCH(c33)

PROVIDE (hardware_init_hook = 0) ;
PROVIDE (software_init_hook = 0) ;
PROVIDE (software_term_hook = 0) ;

SECTIONS
{
	/* data pointer symbol By GWB33 */
	__dp = 0x00000000;

	software_term_hook = 0;

	/* section information By GWB33 */
	. = 0x02000000;

	/* Map vector table */
	__START_vector_lma = 0x0c00000;
	.vector : AT( __START_vector_lma ){
		__START_vector = . ;
		sys_start.o(.data)
	}
	__END_vector = .;
	__END_vector_lma = __START_vector_lma + SIZEOF( .vector );

	/* section information */
	. = __END_vector_lma ;

	.text : {
	   __START_text = . ; 
	   *(.text) 
	}
	__END_text = . ; 

	.rodata : {
	   __START_rodata = . ; 
	   *(.rodata) 
	}
	__END_rodata = . ; 

	. = __END_vector;

	.bss : {
	   __START_bss = . ; 
	   *(.bss) 
	}
	 __END_bss = . ; 

	.data __END_bss : AT( __END_rodata ) {
	   __START_data = . ; 
	   *(.data) 
	}
	__START_data_lma = LOADADDR( .data );
	__END_data_lma = __START_data_lma + SIZEOF( .data );


}
