/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.c,v 1.1 2008/06/17 00:04:35 suikan Exp $
 */

/*
 *	vZbTˑW[iPowerPCpj
 *@@@@@J[lŎgp`
 *@@@@@@C֐̎
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include <sil.h>


/*
 *  ݃nh^݃}XN̋[e[u
 */
FP int_table[TMAX_INTNO];


/*
 *  OxN^̋[e[u
 */
FP exc_table[TMAX_EXCNO];

/*
 *  G[bZ[W̃f[^e[u
 *
 *  Cve[VŗL̗O0x1000̓J[lpӂo
 *  oRȂ̂ŁÃe[u0x10Ԗڂgp
 *  Ƃ͂ȂB
 */
static const char *(exe_list[]) = {
	"",				/*  0x0  */
	"System Reset",			/*  0x1  */
	"Machine Check",		/*  0x2  */
	"DSI",				/*  0x3  */
	"ISI",				/*  0x4  */
	"External Interrupt",		/*  0x5  */
	"Alignment",			/*  0x6  */
	"Program",			/*  0x7  */
	"Floating Point Unavailable",	/*  0x8  */
	"Decrementer",			/*  0x9  */
	"Implement Exception 0xa00",	/*  0xa  */
	"",				/*  0xb  */
	"System Call",			/*  0xc  */
	"Trace",			/*  0xd  */
	"Floating Point Assist",	/*  0xe  */
};


/*
 *  vZbTˑ̏
 */
void
cpu_initialize()
{
    	INHNO i;
    	EXCNO j;

    	/* 
    	 * ݋[xN^e[u
    	 *
    	 *@@0ŏĖo^ɂĂ̂ŁA
    	 *@@ݏICUˑPROC_ICUł́A
    	 *@@o^̏ꍇ̏Ă
         */
    	for( i = 0; i < TMAX_INTNO; i++ ) {
        	define_inh( i, (FP)0 );
    	}

    	/* CPUO[xN^e[u */
    	for( j = 0; j < TMAX_EXCNO; j++ ) {
        	define_exc( j, (FP)&no_reg_exception );
    	}
}

/*
 *  vZbTˑ̏I
 */
void
cpu_terminate()
{
}

#ifdef SUPPORT_CHG_IPM

/*
 *  ݃}XN̕ύX
 *
 *  PowerPCRAɂIPMȂA݃Rg[IPM݈̂
 *  _ɒ
 *
 *  chg_ipm g NMIȊÔׂĂ݂̊֎~ł邩ǂ
 *  ͊݃Rg[ɈˑB
 *  NMIȊÔׂĂ݂̊֎~ꍇɂ́Cloc_cpuɂCPU
 *  bNԂɂ΂悢D
 *  IPMɂĈꕔ݂̊}XNĂ鎞ɂC^XNfBX
 *  pb`͕ۗȂDIPḾC^XNfBXpb`ɂāCV
 *  sԂɂȂ^XNֈpD̂߁C^XN
 *  sɁCʂ̃^XNɂ IPMύXꍇDJSPJ[
 *  lł́CIPM̕ύX̓^XNO[`ɂĂN邪C
 *  ɂĈȂ󋵂͏ȂƎvDIPM ̒l
 *  ɂă^XNfBXpb`֎~ꍇɂ́Cdis_dsp𕹗p
 *  ΂悢D
 */
SYSCALL ER
chg_ipm(IPM ipm)
{
	ER	ercd;

	LOG_CHG_IPM_ENTER(ipm);	/*  ICUˑ  */
	CHECK_TSKCTX_UNL();
	CHECK_IPM(ipm);		/*  ICUˑ  */

	t_lock_cpu();
	CHG_IPM(ipm);		/*  ICUˑ  */
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_CHG_IPM_LEAVE(ercd);
	return(ercd);
}

/*
 *  ݃}XN̎Q
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
	ER	ercd;

	LOG_GET_IPM_ENTER(p_ipm);		/*  ICUˑ  */
	CHECK_TSKCTX_UNL();

	t_lock_cpu();
	GET_IPM(p_ipm);				/*  ICUˑ  */
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_GET_IPM_LEAVE(ercd, *p_ipm);	/*  ICUˑ  */
	return(ercd);
}

#endif /* SUPPORT_CHG_IPM */


/*  CPUO^ݔ̃X^bÑf[^\  */
void syslog_data_on_stack(EXCSTACK *sp)
{
    syslog(LOG_EMERG, "PC = 0x%08x SR = 0x%08x",
    			sp->srr0, sp->srr1);

    syslog(LOG_EMERG, "r0 = 0x%08x ", sp->r0);
    syslog(LOG_EMERG, "r3 = 0x%08x r4 = 0x%08x r5 = 0x%08x",
    			sp->r3, sp->r4, sp->r5);
    syslog(LOG_EMERG, "r6 = 0x%08x r7 = 0x%08x r8 = 0x%08x",
    			sp->r6, sp->r7, sp->r8);
    syslog(LOG_EMERG, "r9 = 0x%08x r10 = 0x%08x r11 = 0x%08x",
    			sp->r9, sp->r10, sp->r11);
    syslog(LOG_EMERG, "r12 = 0x%08x ", sp->r12);


    syslog(LOG_EMERG, "LR = 0x%08x CTR = 0x%08x",
    			sp->lr, sp->ctr );
    syslog(LOG_EMERG, "CR = 0x%08x XER = 0x%08x",
    			sp->cr, sp->xer );
}


/*
 * o^ĂȂOƌĂяo
 */

void no_reg_exception(EXCSTACK *sp)
{
    syslog(LOG_EMERG, "Exception error occurs.");
    syslog(LOG_EMERG, " [0x%02x]: %s", 
    	   sp->exc_no, exe_list[sp->exc_no]);

    /*  X^bÑf[^̕\  */
    syslog_data_on_stack(sp);

    while(1);
}


/*
 *  ubN색Cu
 *	(ItIs̗p)
 *
 *  ֐̎dĺCANSI C Cu̎dlƓDWCû̂
 *  gǂ\D
 *
 */
VP
_dummy_memcpy(VP dest, VP src, UINT len)
{
	VB *d = (VB *)dest;
	VB *s = (VB *)src;

	while (len-- > 0) {
		*d++ = *s++;
	}
	return(dest);
}

/*  end of file  */
