/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2005 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN    
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: nios2.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#ifndef _NIOSII_H_
#define _NIOSII_H_

#ifndef _MACRO_ONLY
#include <itron.h>
#endif /* _MACRO_ONLY */

/*
 *  ݃rbg
 */
#define STATUS_U   0x02
#define STATUS_PIE 0x01

/*
 * ݂̐
 */
#define MAX_INT_NUM 32

/*
 * Ǒ
 */
#define MAX_EXC_NUM 32


/*
 *  Timer
 *  Full-featuredT|[g 
 */

/*
 * ItZbgl
 */
#define TIM_STATUS_OFFSET  0x00
#define TIM_CONTROL_OFFSET 0x04
#define TIM_PERIODL_OFFSET 0x08
#define TIM_PERIODH_OFFSET 0x0C
#define TIM_SNAPL_OFFSET 0x10
#define TIM_SNAPH_OFFSET 0x14

#define TIM_STATUS_RUN 0x02
#define TIM_STATUS_TO  0x01

#define TIM_CONTROL_STOP  0x08
#define TIM_CONTROL_START 0x04
#define TIM_CONTROL_COUNT 0x02
#define TIM_CONTROL_ITO   0x01

/*
 *
 */
#define TIM_STATUS  (TIM_BASE + TIM_STATUS_OFFSET)
#define TIM_CONTROL (TIM_BASE + TIM_CONTROL_OFFSET)
#define TIM_PERIODL (TIM_BASE + TIM_PERIODL_OFFSET)
#define TIM_PERIODH (TIM_BASE + TIM_PERIODH_OFFSET)
#define TIM_SNAPL   (TIM_BASE + TIM_SNAPL_OFFSET)
#define TIM_SNAPH   (TIM_BASE + TIM_SNAPH_OFFSET)


/*
 * UART
 */
#define UART_RXDATA_OFFSET  0x00
#define UART_TXDATA_OFFSET  0x04
#define UART_STATUS_OFFSET  0x08
#define UART_CONTROL_OFFSET 0x0C
#define UART_DIVISOR_OFFSET 0x10
#define UART_ENDOFPACKET_OFFSET 0x1C

#define UART_STATUS_EOP   0x1000
#define UART_STATUS_CTS   0x0800
#define UART_STATUS_DCTS  0x0400
#define UART_STATUS_E     0x0100
#define UART_STATUS_RRDY  0x0080
#define UART_STATUS_TRDY  0x0040
#define UART_STATUS_TMT   0x0020
#define UART_STATUS_TOE   0x0010
#define UART_STATUS_ROE   0x0008
#define UART_STATUS_BRK   0x0004
#define UART_STATUS_FE    0x0002
#define UART_STATUS_PE    0x0001

#define UART_CONTROL_IEOP  0x1000
#define UART_CONTROL_RTS   0x0800
#define UART_CONTROL_IDCTS 0x0400
#define UART_CONTROL_TRDK  0x0200
#define UART_CONTROL_IE    0x0100
#define UART_CONTROL_IRRDY 0x0080
#define UART_CONTROL_ITRD  0x0040
#define UART_CONTROL_ITMT  0x0020
#define UART_CONTROL_ITOE  0x0010
#define UART_CONTROL_IROE  0x0008
#define UART_CONTROL_IBRK  0x0004
#define UART_CONTROL_IFE   0x0002
#define UART_CONTROL_IPE   0x0001

#define UART_RXDATA  (UART_BASE + UART_RXDATA_OFFSET)
#define UART_TXDATA  (UART_BASE + UART_TXDATA_OFFSET)
#define UART_STATUS  (UART_BASE + UART_STATUS_OFFSET)
#define UART_CONTROL (UART_BASE + UART_CONTROL_OFFSET)
#define UART_DIVISOR (UART_BASE + UART_DIVISOR_OFFSET)
#define UART_ENDOFPACKET (UART_BASE + UART_ENDOFPACKET_OFFSET)


/*
 * JTAG UART֘A
 */ 
#define JTAG_UART_DATA_OFFSET    0x00
#define JTAG_UART_CONTROL_OFFSET 0x04

#define JTAG_UART_DATA_RVALID 0x8000

#define JTAG_UART_CONTROL_RIE 0x01
#define JTAG_UART_CONTROL_WIE 0x02
#define JTAG_UART_CONTROL_RIP 0x04
#define JTAG_UART_CONTROL_WIP 0x08
#define JTAG_UART_CONTROL_WSAPCE 0x0ffff0000

#define JTAG_UART_DATA    (UART_BASE + JTAG_UART_DATA_OFFSET)
#define JTAG_UART_CONTROL (UART_BASE + JTAG_UART_CONTROL_OFFSET)


#ifndef _MACRO_ONLY

/*                                                                          
 * UARTp ȈSIOhCo                                                 
 */

/*                                                                            
 *  VAI/O|[gubN                                         
 */
typedef struct sio_port_initialization_block {

} SIOPINIB;

/*                                                                            
 *  VAI/O|[gǗubN                                            
 */
typedef struct sio_port_control_block {
    const SIOPINIB  *siopinib;  /* VAI/O|[gubN */
    VP_INT          exinf;      /* g */
    BOOL    openflag;           /* I[vς݃tO */
    BOOL    sendflag;           /* M݃Cl[utO */
    BOOL    getready;           /* M */
    BOOL    putready;           /* 𑗐Mł */
} SIOPCB;

extern SIOPCB   siopcb_table[];

#define uart_openflag   (siopcb_table[0].openflag)

Inline void
uart_putc(unsigned char c){
#ifndef USE_JTAG_UART	
	while(!(sil_rew_mem((VP)UART_STATUS) & UART_STATUS_TRDY));
	sil_wrw_mem((VP)UART_TXDATA, c);
#else
	while(!((sil_rew_mem((VP)JTAG_UART_CONTROL) & JTAG_UART_CONTROL_WSAPCE) > 0));
	sil_wrw_mem((VP)JTAG_UART_DATA, c);	
#endif /* USE_JTAG_UART	*/	
}

Inline unsigned char
uart_getc(void){
#ifndef USE_JTAG_UART	
	while(!(sil_rew_mem((VP)UART_STATUS) & UART_STATUS_RRDY));
	return (char)(sil_rew_mem((VP)UART_RXDATA));
#else
	int tmp;
	do{
		tmp = sil_rew_mem((VP)JTAG_UART_DATA);
	}while((tmp &JTAG_UART_DATA_RVALID) == 0);

	return (char)tmp;
#endif /* USE_JTAG_UART	*/			
}

/*
 *  R[obN[`̎ʔԍ
 *  OPB_UARTLITE ́CM݂ĂȂ߁CӖ͂ȂD
 */
#define SIO_ERDY_SND    1u              /* M\R[obN */
#define SIO_ERDY_RCV    2u              /* MʒmR[obN */


/*                                                                           
 *  SIOhCȍ[`                                                
 */
extern void uart_initialize(void);


/*                                                                           
 *  VAI/O|[g̃I[v                                              
 */
extern SIOPCB   *uart_opn_por(ID siopid, VP_INT exinf);

/*                                                                         
 *  VAI/O|[g̃N[Y                                             
 */
extern void uart_cls_por(SIOPCB *siopcb);

/*                                                                            
 *  VAI/O|[gւ̕M                                            
 */
extern BOOL uart_snd_chr(SIOPCB *siopcb, INT chr);

/*
 *  VAI/O|[g̕M
 */
extern INT  uart_rcv_chr(SIOPCB *siopcb);


/*
 *  VAI/O|[g̃R[obN̋
 */
extern void uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn);


/*
 *  VAI/O|[g̃R[obN̋֎~
 */
extern void uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn);


/*                                                                            
 *  SIO̊݃T[rX[`                                              
 */
extern void uart_isr(void);


/*
 *  VAI/O|[g̑M\R[obN
 */
extern void uart_ierdy_snd(VP_INT exinf);


/*
 *  VAI/O|[g̎MʒmR[obN
 */
extern void uart_ierdy_rcv(VP_INT exinf);

#endif  /* _MACRO_ONLY */

#endif /* _NIOSII_H_ */

