/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#include "jsp_kernel.h"
#include <hw_serial.h>		/* VARg[֌W */

/*  ݃Rg[ɗp銄݃}XN̋[e[u  */
ICU_IPM icu_intmask_table[ TMAX_ALL_INTNO ];

/*
 *  ^[QbgVXeˑ [`
 */
void sys_initialize() {

	ICU_IPM icu_ipm0 = {INIT_INT0M, INIT_INT1M};

	/*
	 *  O݃Rg[̊݃}XN̏
	 */
	icu_set_ipm( &icu_ipm0 );

	/*
	 *  oi[\pVA|[g̏
	 */
	sio_init();
}

/*
 *  ^[QbgVXȅI[`
 */
void sys_exit(void) {

#ifndef GDB_STUB
	while (1);
#else	/*  GDB_STUB  */
	vr5500_exit();
#endif	/*  GDB_STUB  */

}

/*
 *  GDB STUB / ڌďo R\[ďo[`
 */

/*
 *  gdb stub ɂR\[o
 */
/* a0($4) = 0xfe00, a1($5) = o͂LN^ āA
   SYSCALL O𔭐B */

/* ̊֐Ăяoɂ́AXe[^XWX^EXLrbg = 0 ŌĂяoƁB
   ȂA݁AJ[lł́Aoi[\AVAo͎ɌďosĂB*/
Inline void stub_putc(int c) {

	Asm("	move	$5, %0;		\
	     	li	$4, 0xfe00;	\
		syscall;		\
		nop"
		:: "r"(c)
		: "$4","$5" );
}

#ifdef GDB_STUB
#define vr5500_putc(c) stub_putc( c )
#else  /* GDB_STUB */
#define	vr5500_putc(c) sio_snd_chr_pol( c )
#endif /* GDB_STUB */

/*
 *   VXeo͐̎w
 */
void
sys_putc(char c)
{
	if (c == '\n') {
		vr5500_putc('\r');
	}
	vr5500_putc(c);
}

