/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _RTE_VR5500_CB_
#define _RTE_VR5500_CB_

#define RTE_VR5500_CB

/*
 *  foCX̊蓖ăx[XAhX
 */

/* VARg[ (TL16PIR552) */
#define UART_CH01	0xb9001000
#define UART_CH02	0xb9002000
#define PRINTER_PPCS	0xb9003000
#define PRINTER_ECPCS	0xb9004000

/* ^C} (uPD71054) */
#define TIMER_BASE_ADDR	0xb9005000

/* ݃Rg[(PIC) */
#define ICU_BASE_ADDR	0xb9000000

/*
 *  foCXɋNbN
 */
/* VAɋNbNg [Hz]i{[[gݒŎgpj
 * i16MHz = 16000000 Hz ; {[h̃}jAp21QƁj */
#define XIN_CLOCK	16000000u

/* ^C}ɋNbNg [kHz]
 *iTO_CLOCK 1~b(1kHz)𔭐邽߂Ɏgpj
 * (2MHz = 2000kHz ; {[h̃}jAp22Q) */
#define TIMER_CLOCK	2000u

/*
 *  foCX̊݃}XN̒`
 *
 *  Dx : () VAP -> VAO -> ^C}O ()
 */

/*
 *  VAO݂̊݃}XNiMpj
 *  E݃x͑MMxɐݒ肵Ă
 */
#define CORE_IPM_SCC		INIT_CORE_IPM	/* MIPS3RA(SR)pf[^ */

#define ICU_IPM_INT0_SCC0	TIMER0		/* ݃Rg[pf[^ */
#define ICU_IPM_INT1_SCC0	0u

/*  ݒ肷銄݃}XNiIPM^ŋLqj */
#define IPM_SCC0	{ CORE_IPM_SCC, {ICU_IPM_INT0_SCC0, ICU_IPM_INT1_SCC0} }

/*
 *  VAP݂̊݃}XNiMpj
 *  E݃x͑MMxɐݒ肵Ă
 *  EMIPS3RAp̃f[^́ASCC0Ƌ
 */
#define ICU_IPM_INT0_SCC1	(TIMER0 | SERIAL0) /* ݃Rg[pf[^ */
#define ICU_IPM_INT1_SCC1	0u

/*  ݒ肷銄݃}XNiIPM^ŋLqj */
#define IPM_SCC1	{ CORE_IPM_SCC, {ICU_IPM_INT0_SCC1, ICU_IPM_INT1_SCC1} }

/*
 *  ^C}O݂̊݃}XN
 *  {ł́A^C}݂Ƃ́ASĂ̊O݂֎~ĂB
 */
#define CORE_IPM_TIMER		INIT_CORE_IPM	/* MIPS3RA(SR)pf[^ */

#define ICU_IPM_INT0_TIMER0	0u		/* ݃Rg[pf[^ */
#define ICU_IPM_INT1_TIMER0	0u

/*  ݒ肷銄݃}XNiIPM^ŋLqj */
#define IPM_TIMER0	{ CORE_IPM_TIMER, {ICU_IPM_INT0_TIMER0, ICU_IPM_INT1_TIMER0} }

#endif /* _PIC_ICU_H_ */
