/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#define _MACRO_ONLY

#include "jsp_kernel.h"

	.set noreorder
	.align 2

/*
 *  ^[Qbgn[hEFAˑ鏉 (reset.S Ăяo)
 */
#ifndef GDB_STUB

	.section .reset
	.global	hardware_init_hook

hardware_init_hook:

	/*
	 *  oXRg[jbg(BCU)֌W̏ݒ
	 */
	li	t0, ASM_SIL( ROMSIZEREG )
	lh	t1, (t0)
	ori	t1, t1, (SIZE3_4 | SIZE2_4 | SIZE1_4 | SIZE0_4)
	sh	t1, (t0)

	li	t0, ASM_SIL( ROMSPEEDREG )
	lh	t1, (t0)
	ori	t1, t1, (ROM4_WAIT_5VTClock | ROM2_WAIT_8VTClock)
	sh	t1, (t0)

	li	t0, ASM_SIL( BCUCNTREG3 )
	lh	t1, (t0)
	ori	t1, t1, (EXT_ROMCS_3ROM_2ROM | IO32 | LCDSEL1_BUFFER | LCDSEL0_BUFFER)
	sh	t1, (t0)

	/*
	 * SDRAMRg[jbg(SDRAMU)֌W̏ݒ
	 */

	li	t0, ASM_SIL( SDRAMMODEREG )
	lh	t1, (t0)
	ori	t1, t1, (SCLK | LTMODE_2)
	sh	t1, (t0)

	li	t0, ASM_SIL( SDRAMCNTREG )
	lh	t1, (t0)
	ori	t1, t1, (TRC_3VTClock | TDAL_2VTClock | TRCD_2VTClock)
	sh	t1, (t0)

	li	t0, ASM_SIL( BCURFCNTREG )
	lh	t1, (t0)
	ori	t1, t1, 0x3ec
	sh	t1, (t0)

	li	t0, ASM_SIL( BCURFCNTREG )
	lh	t1, (t0)
	ori	t1, t1, 0x3ec
	sh	t1, (t0)

	li	t0, ASM_SIL( RAMSIZEREG )
	lh	t1, (t0)
	ori	t1, t1, (SIZE3_64 | SIZE2_64 | SIZE1_64 | SIZE0_64)
	sh	t1, (t0)

	/*
	 *  oXRg[jbg(BCU)֌W̏ݒ
	 */
	li	t0, ASM_SIL( IO0SPEEDREG )
	lh	t1, (t0)
	ori	t1, t1, IO0_1_WAIT_4
	sh	t1, (t0)

	li	t0, ASM_SIL( IO1SPEEDREG )
	lh	t1, (t0)
	ori	t1, t1, IO1_3_WAIT_11
	sh	t1, (t0)

	/*
	 *  HALTimerVbg_ẼNA
	 *  CPUNA4bȓɍsȂ΂ȂȂ
	 *  PMURg[WX^HALTimerZbgrbgɂP
	 */
	li	t0, ASM_SIL( PMUCNTREG )
	lh	t1, (t0)
	ori	t1, t1, HALTIMERRST
	sh	t1, (t0)

	/*
	 *  HALTimerZbg̃NA
	 *  PMU݁^Xe[^XWX^TIMOUTRSTrbgɂP
	 */
	li	t0, ASM_SIL( PMUINTREG )
	lh	t1, (t0)
	ori	t1, t1, TIMOUTRST
	sh	t1, (t0)

	/*
	 * TLB̏
	 */
tlb_initialize:
	mtc0	zero, PageMask
	mtc0	zero, EntryLo0
	mtc0	zero, EntryLo1

	li	t0, TMAX_TLB
	li	t1, 0xA0000000		/* kseg1 ̒DRAM̏gp */
loop_TLB_clear:
	mtc0	t0, Index
	mtc0	t1, EntryHi
	addiu	t0, t0, -1
	addiu	t1, t1, TLB_VPN2	/* 1y[W4koCgŁA2y[W}bs
					   O邽 */
	tlbwi
	bgez	t0, loop_TLB_clear
	nop

	/*
	 * LbV̏
	 */
cache_initialize:
	mtc0	zero, TagLo
	mtc0	zero, TagHi

	li	t0, 0x80001ff0	/* 512 line  (1 line = 16 byte) */
	li	t1, 0x80000000
loop_I_cache_clear:
	cache	Index_Invalidate_I, 0x0000(t0)
	cache	Index_Invalidate_I, 0x2000(t0)
	bne	t0, t1, loop_I_cache_clear
	addiu	t0, t0, -I_CACHE_LINE_SIZE

	li	t0, 0x80001ff0	/* 512 line  (1 line = 16 byte) */
	li	t1, 0x80000000
loop_D_cache_clear:
	cache	Index_Store_Tag_D, 0x0000(t0)
	cache	Index_Store_Tag_D, 0x2000(t0)
	bne	t0, t1, loop_D_cache_clear
	addiu	t0, t0, -D_CACHE_LINE_SIZE

	/*
	 * Ăяoփ^[
	 */
return_to_common:
	j	ra
	nop

#endif /* GDB_STUB */
