/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _KZ_VR4131PCI_01_
#define _KZ_VR4131PCI_01_

#define KZ_VR4131PCI_01

/*
 *  foCX̊蓖ăx[XAhX
 */

#define VR4131_BASE_ADDR	0xa0000000

/*
 *  foCXɋNbN
 */
/*
 *  VR4131 ͋N CLKSEL(2:0) [qāApCvCNbNPClock
 *  肷B̃^[Qbg{[h̃ftHǵA
 *        CLKSEL(2:0) = 110
 *  p[}lWgjbǵAPMUTCLKDIVREGɕύX͉Ȃ߉LƂȂB
 *        PClock 199.1[MHz], VTClock 33.2[MHz], TClock 16.6[MHz]
 */
/* VAɋNbNg [Hz]i{[[gݒŎgpj
 * i18.432MHz = 18432000 Hz ; n[hEFAp193QƁj */
#define XIN_CLOCK	18432000u	/* [Hz] */

/* ^C}ɋNbNg [kHz]iTO_CLOCKŎgpj
 * iTO_CLOCK 1~b(1kHz)𔭐邽߂Ɏgpj
 * iVTClock=33.2MHz = 33200kHz ; n[hEFAp22QƁj */
#define TIMER_CLOCK	33200u	/* [kHz] */

/*
 *  foCX̊݃}XN̒`
 *
 *  Dx : () DSIU -> TClockJE^ -> obecʕsm ()
 */
/* MSYSINT1  BATINTR ̐ݒɂẮAn[hEFAp224Q  */

/*
 *  DSIU ݂̊݃}XNiMpj
 *  E݃x͑MMxɐݒ肵Ă
 */
#define CORE_IPM_DSIU		INIT_CORE_IPM	/* MIPS3RA(SR)pf[^ */

/* BATINTRATCLKINTR ݂݂̂B */
#define ICU_IPM_SYSINT1_DSIU	BATINTR		/* ݃Rg[pf[^ */
#define ICU_IPM_SYSINT2_DSIU	TCLKINTR

/*  ݒ肷銄݃}XNiIPM^ŋLqj */
#define IPM_DSIU	{ CORE_IPM_DSIU, {ICU_IPM_SYSINT1_DSIU, ICU_IPM_SYSINT2_DSIU} }

/*
 *  RTC ֘Å݃}XN
 */
#define CORE_IPM_TIMER		INIT_CORE_IPM	/* MIPS3RA(SR)pf[^ */

/* BATINTR ݂݂̂B */
#define ICU_IPM_SYSINT1_TCLK	BATINTR		/* ݃Rg[pf[^ */
#define ICU_IPM_SYSINT2_TCLK	0u

/*  ݒ肷銄݃}XNiIPM^ŋLqj */
#define IPM_TIMER	{ CORE_IPM_TIMER, {ICU_IPM_SYSINT1_TCLK, ICU_IPM_SYSINT2_TCLK} }

#endif /* _KZ_VR4131PCI_01_ */
