/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

/*
 *   ^C}hCoiVR4131RTCTClock^C}pj
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <vr4131_rtc.h>

/*
 *  ^C}݃nh̃xN^ԍ
 */
#define	INHNO_TIMER	INTNO_TCLK

#ifndef _MACRO_ONLY

/*
 *  ^C}l̓\̌^
 */
typedef UH		CLOCK;

#endif /* _MACRO_ONLY */

/*
 *  ^C}l̓\ƃ~bEʕbPʂƂ̕ϊ
 *  TIMER_CLOCḰA{[h֌W̃wb_t@CɋLڂĂB
 */
/* 1~b(isig_tim Ăяo;1kHz)𔭐邽߂̃JEg */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
/* clock  usec Pʂɕϊ}N */
#define	TO_USEC(clock)		((clock) * 1000u / TIMER_CLOCK)

/*
 *  ^C}̒Pʂ\ɕϊ
 *  (p^C}_EJE^Ȃ̂ŁÃ}Nƕ֗)
 */
#define CLOCK_PER_TICK		((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ݒłő̃^C}iPʂ͓\j
 */
#define MAX_CLOCK		((CLOCK) 0x1ffffff)	/*  25rbg  */

/*
 *  ^C}̌ݒlݔO̒lƂ݂Ȃ̔f
 */
#define	GET_TOLERANCE		100u	/* x̌ςliPʂ͓\j*/
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ^C}~܂ł̎ԁinsecPʁj
 *  lɍ͂ȂD
 */
#define	TIMER_STOP_DELAY	200u

#ifndef _MACRO_ONLY
/*
 *  ^C}ݗṽNA
 */
Inline void hw_timer_int_clear() {

	vr4131_wrh_mem( (VP) RTCINTREG, RTCINTR3 );
}

/*
 *  ^C}̋N
 *    ^C}CIȃ^C}ݗv𔭐D
 */
Inline void hw_timer_initialize() {

	/*
	 *  ^C}ݒ肵C^C}̓JnD
	 */
	assert( CLOCK_PER_TICK <= MAX_CLOCK );

	vr4131_wrh_mem( (VP) TCLKLREG, (UH) LO16(CLOCK_PER_TICK) );
	vr4131_wrh_mem( (VP) TCLKHREG, (UH) HI16(CLOCK_PER_TICK) );

	/*
	 *  ^C}݂̊݃xݒ肵CvNAC
	 *  }XND
	 */
	all_set_ilv( INHNO_TIMER, &((IPM) IPM_TIMER) );	/* ݃x̐ݒ */

	hw_timer_int_clear();				/* ݗvNA */

	/* }XN(xPAxQɑ郌WX^͖) */
	vr4131_orh( (VP) MSYSINT2REG, TCLKINTR );
}

/*
 *  ^C}̒~
 *  ^C}̓~D
 */
Inline void hw_timer_terminate() {

	/*  ^C}̓~  */
	vr4131_wrh_mem( (VP) TCLKLREG, 0 );
	vr4131_wrh_mem( (VP) TCLKHREG, 0 );

	/*
	 *  ^C}݂}XNCvNAD
	 */
	/* }XNݒ菈(xPAxQɑ郌WX^͖) */
	vr4131_andh( (VP) MSYSINT2REG, ~TCLKINTR );

	hw_timer_int_clear();				/* ݗvNA */
}

/*
 *  ^C}̌ݒl̓Ǐo
 */
Inline CLOCK hw_timer_get_current() {

	UH 	count;
	UH	hi1, lo1, hi2, lo2;

	/* JE^l̓ǂݏo */
	/* 2ǂݏoĂ闝ŔAn[hEFAp261Q */
	lo1 = vr4131_reh_mem( (VP) TCLKCNTLREG );
	hi1 = vr4131_reh_mem( (VP) TCLKCNTHREG );

	lo2 = vr4131_reh_mem( (VP) TCLKCNTLREG );
	hi2 = vr4131_reh_mem( (VP) TCLKCNTHREG );

	if( hi2 == hi1 )
		count = JOIN16( hi1, lo1 );
	else
		count = JOIN16( hi2, lo2 );

	return (CLOCK_PER_TICK - count);
}

/*
 *  ^C}ݗṽ`FbN
 */
Inline BOOL hw_timer_fetch_interrupt() {

	return( ( vr4131_reh_mem( (VP) RTCINTREG ) & RTCINTR3 ) != 0);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
