/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

/*
 *	VAI/OfoCXiSIOjhCoiVR4131DSIUpj
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <vr4131_dsiu.h>		/* siopcb, vr4131_dsiu_openflag */

/*
 *  SIO̊݃nh̃xN^ԍ
 */
#define INHNO_SIO		INTNO_DSIU

/*
 *  SIOhCȍ[`
 */
#define	sio_initialize		vr4131_dsiu_initialize

/*
 *  J[lNp̏ (sys_putcŗp)
 */
#define sio_init		vr4131_dsiu_init

#ifndef _MACRO_ONLY

/*
 *  VAI/O|[g̃I[v
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	/*
	 *  I[v|[g邩 openflag ɓǂłD
	 */
	openflag = vr4131_dsiu_openflag();

	/*
	 * DSIUւ̃NbNJn
	 */
	vr4131_orh( (VP) CMUCLKMSK, (MSKDSIU | MSKSSIU | MSKSIU) );

	/*
	 *  foCXˑ̃I[vD
	 */
	siopcb = vr4131_dsiu_opn_por(siopid, exinf);

	/*
	 *  VAI/O݂̊݃xݒ肵C}XND
	 */
	if (!openflag) {
		/* ݃xݒ */
		all_set_ilv( (UINT) INTNO_DSIU, &((IPM) IPM_DSIU) );

		/* }XN(xP) */
		vr4131_orh( (VP) MSYSINT2REG, DSIUINTR );

		/* }XN(xQ) */
		vr4131_orh( (VP) MDSIUINTREG, INTDSIU );
	}

	return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  VAI/O݂}XND
	 */
	if (!vr4131_dsiu_openflag) {
		/* }XNݒ菈(xP) */
		vr4131_andh( (VP) MSYSINT2REG, ~DSIUINTR );

		/* }XNݒ菈(xQ) */
		vr4131_andh( (VP) MDSIUINTREG, ~INTDSIU );
	}

	/*
	 *  foCXˑ̃N[YD
	 */
	vr4131_dsiu_cls_por(siopcb);

	/*
	 *  DSIUւ̃NbN~
	 */
	vr4131_andh( (VP) CMUCLKMSK, ~(MSKDSIU | MSKSSIU | MSKSIU) );

}

#endif /* _MACRO_ONLY */

/*
 *  SIO̊݃nh
 */
#define	sio_handler		vr4131_dsiu_isr

/*
 *  VAI/O|[gւ̕M
 */
#define	sio_snd_chr		vr4131_dsiu_snd_chr

/*
 *  VAI/O|[gւ̕Mi|[Oj
 */
#define	sio_snd_chr_pol		vr4131_dsiu_putchar_pol

/*
 *  VAI/O|[g̕M
 */
#define	sio_rcv_chr		vr4131_dsiu_rcv_chr

/*
 *  VAI/O|[g̃R[obN̋
 */
#define	sio_ena_cbr		vr4131_dsiu_ena_cbr

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
#define	sio_dis_cbr		vr4131_dsiu_dis_cbr

/*
 *  VAI/O|[g̑M\R[obN
 */
#define	sio_ierdy_snd		vr4131_dsiu_ierdy_snd

/*
 *  VAI/O|[g̎MʒmR[obN
 */
#define	sio_ierdy_rcv		vr4131_dsiu_ierdy_rcv

#endif /* _HW_SERIAL_H_ */
