/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef _UTIL_H_
#define _UTIL_H_

/*
 *  rbgԍ̒`
 */
#define BIT0              0x1
#define BIT1              0x2
#define BIT2              0x4
#define BIT3              0x8
#define BIT4             0x10
#define BIT5             0x20
#define BIT6             0x40
#define BIT7             0x80
#define BIT8            0x100
#define BIT9            0x200
#define BIT10           0x400
#define BIT11           0x800
#define BIT12          0x1000
#define BIT13          0x2000
#define BIT14          0x4000
#define BIT15          0x8000
#define BIT16         0x10000
#define BIT17         0x20000
#define BIT18         0x40000
#define BIT19         0x80000
#define BIT20        0x100000
#define BIT21        0x200000
#define BIT22        0x400000
#define BIT23        0x800000
#define BIT24       0x1000000
#define BIT25       0x2000000
#define BIT26       0x4000000
#define BIT27       0x8000000
#define BIT28      0x10000000
#define BIT29      0x20000000
#define BIT30      0x40000000
#define BIT31      0x80000000

/*
 *  oCgf[^p}N
 */
/* ȉɂāAxFs */

/* ȉ̂悤ȏƁAǂǂH
     (UH) (((UW) (c)) & 0x0000ffff)
     (UH) (((UW) (c)) & 0xffff0000) >> 16
*/

/* (UH) xxaa -> (UB) aa */
#define LO8(c)		(UB)( (UH)(c) & 0xff )	/*  1oCgo  */
/* (UH) aaxx -> (UB) aa */
#define HI8(c)		LO8( (UH)(c) >>  8 )	/*  1oCgo  */

/* (UW) xxxxaaaa -> (UH) aaaa */
#define LO16(c)		(UH)( (UW)(c) & 0xffff )/*  2oCgo  */
/* (UW) aaaaxxxx -> (UH) aaaa */
#define HI16(c)		LO16( (UW)(c) >> 16 )	/*  2oCgo  */

/* (UH) aaaa, (UH) bbbb -> (UW) aaaabbbb */
#define JOIN16(hi, lo)	(UW)( ((UW)(hi) << 16) | (lo) )	/*  2oCgf[^̌  */
/* (UB) aa, (UB) bb -> (UH) aabb */
#define JOIN8(hi, lo)	(UH)( ((UH)(hi) <<  8) | (lo) )	/*  1oCgf[^̌  */

/* (UB) xxxxaaaaiQij -> (UB) ooooaaaaiQij */
#define TO_LO4(c)	( (UB)(c) & 0xf )		/*  0-3rbgɔzu  */
/* iQijxxxxaaaa -> iQijaaaaoooo */
#define TO_HI4(c)	(((UB)(c) << 4) & 0xf0)		/*  4-7rbgɔzu  */

/*
 *  lf[^񉻗p}N
 */
#define _TO_STRING(arg)	#arg
#define TO_STRING(arg)	_TO_STRING(arg)

#endif /* _UTIL_H_ */
