/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#define _MACRO_ONLY

#include "jsp_kernel.h"		/* INIT_SR */

/*
 *   MIPS3pX^[gAbvW[
 *     ZbgxN^  0xbfc00000Ԓnɔzu
 *   
 *   J[l̓AvP[VƃNĎgp邾Ȃ̂
 *   JSPJ[l̂ݎgpB
 */

	.section ".reset","xa"

	.set noreorder

	.align 2
	.global	reset

reset:
	/*
	 *  CPUWX^̏
	 */

	/* HI, LO (揜ZWX^) */
	mthi	zero
	mtlo	zero

	/* sp (X^bN|C^G^XNReLXgp)
	     _stack_top ́AVXeˑ(JXNvg)` */
	la	sp, _stack_top

	/* gp (O[o|C^)
	     _gp ́AVXeˑ(JXNvg)` */
	la	gp, _gp

	/* k0 (/CPUOlXgJE^p) */
	li	k0, 0x1		/* ^XNN܂ł́A^XNReLXgł
				   sƂ݂ȂB */
	/* k1́AɔėpƂėpĂ̂ŏȂB */

	/*
	 *  CP0WX^̏
	 */

	/* SR (Xe[^XWX^)
	     (ŃRÅ݃}XNݒ肷B́AIȊݐ́A
	     O݃Rg[ōs߁B)
	     INIT_SR ́Asys_config.h Œ` */
	li	t0, INIT_SR
	mtc0	t0, Status

	/* Config (RtBOWX^)
	     INIT_CONFIG_MASK ́Asys_config.h Œ` */
	mfc0	t0, Config
	li	t1, INIT_CONFIG_MASK
	or	t0, t0, t1
	mtc0	t0, Config

	/* WatchLo (EHb`LoWX^) */
	mtc0	zero, WatchLo

	/* Compare (rWX^) */
	li	t0, 0xffffffff
	mtc0	t0, Compare

	/*
	 *  hardware_init_hook ĂяoB(0łȂꍇ)
	 *
	 *  E^[Qbgn[hEFAɈˑ鏉ꍇ́C
	 *    hardware_init_hook Ƃ֐pӂD
	 *      jROM̍ہARAMgp\ɂ邽߂̃oXRg[̏
	 *    ́Asys_support.S  hardware_init_hook `ĂD
	 */
hardware_init:
	la	t0, hardware_init_hook
	beq	t0, zero, bss_clear
	nop
	jalr	ra, t0
	nop

	/*
         * bssZNVNA
	 */
bss_clear:
	la	t1, __bss_start
	la	t2, __bss_end
	beq	t1, t2, data_sec_copy
	nop
        sw	zero, (t1)
loop_bss_clear:
        addi	t1, t1, 4
        sub	t3, t2, t1
        bgez 	t3, loop_bss_clear
        sw	zero, (t1)

	/*
	 *  dataZNV (ROMΉ)
	 *
	 *  __idata_start  __idata_end ܂łC__data_start ȍ~ɃRs[
	 */
data_sec_copy:
	la	t1, __idata_start
	la	t2, __idata_end
	beq	t1, t2, software_init
	nop
	la	t3, __data_start
loop_data_sec_copy:
	lw	t5, (t1)
        sw	t5, (t3)
        addi	t1, t1, 4
        addi	t3, t3, 4
        sub	t4, t2, t1
        bgtz 	t4, loop_data_sec_copy
	nop

	/*
	 *  software_init_hook Ăяoi0 łȂꍇj
	 *
	 *  \tgEFAiɃCujɈˑĕKvȏ
	 *  ꍇ́Csoftware_init_hook Ƃ֐pӂD
	 */
software_init:
	la	t0, software_init_hook
	beq	t0, zero, start_kernel
	nop
	jalr	ra, t0
	nop

	/*
         *  J[lN
	 */
start_kernel:
	la	t0, kernel_start
	j	t0
	nop
