/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

#include <mips3.h>

#ifndef _MACRO_ONLY

/*
 *  Xe[^XWX^̑֐
 */

/* Xe[^XWX^iSRǰݒl̓Ǐo */
Inline UW current_sr(void) {

	UW	sr;

	Asm( "mfc0 %0, "str_Status : "=r"(sr) );

	return( sr );
}


/* Xe[^XWX^iSRǰݒl̕ύX */
Inline void set_sr(UW sr) {

	Asm( "mtc0 %0, "str_Status : : "r"(sr) );
}


/* NMIׂĂ݂̊֎~ */
Inline void disint(void) {

	set_sr( (current_sr() & ~SR_IE) );
}


/* ݂ */
Inline void enaint() {

	set_sr( (current_sr() | SR_IE) );
}

/*
 *  ݃}XN색CuiMIPS3RApj
 */

/* ݃}XN̐ݒ */
Inline void cpu_set_ipm(CORE_IPM intmask) {

	set_sr( (CORE_IPM) ((current_sr() & ~SR_IM) | intmask) );
}

/* ݃}XN̓Ǐo */
Inline CORE_IPM cpu_get_ipm() {

	return( (CORE_IPM)  (current_sr() &  SR_IM) );
}

#endif /* _MACRO_ONLY */
#endif /* _CPU_INSN_H_ */
