/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_timer.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

/*
 * CPUˑ^C}W[iMicroBlazepj
 */ 
#include <s_services.h>
#include <microblaze.h>

/*
 * ^C}݃nh̊ݔԍ
 */
#define INHNO_TIMER TIMINTLVL

#ifndef _MACRO_ONLY

/*
 * ^C}l̓\̌^
 */
typedef UW CLOCK;

/*                                                                             
 *  ^C}l̓\ƃ~bEʕbPʂƂ̕ϊ                               
 *  TIMER_CLOCK ̓^[Qbg{[hɐݒ                                     
 */
#define TO_CLOCK(nume, deno)  (TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)      ((clock) * 1000 / TIMER_CLOCK)

/*
 *  ݒłő^C}iPʂ͓\j
 */
#define MAX_CLOCK ((CLOCK) 0xffffffff)

/*
 *  \]pVXeoۂ̏Ԃ̌ςliPʂ͓\j
 */
#define GET_TOLERANCE	100
#define BEFORE_IREQ(clock) \
        ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)


/*
 * ^C}̋N
 *
 * ^C}CIȃ^C}݂𔭐
 */ 
Inline void
hw_timer_initialize(void)
{
  
  CLOCK cyc = TO_CLOCK(TIC_NUME, TIC_DENO);

  sil_wrw_mem((VP)TIMER_TCSR0,TIMER_RESET); /* Zbg */
  
  assert(cyc <= MAX_CLOCK);	                /* ^C}l̃`FbN */
  sil_wrw_mem((VP)TIMER_TCCR0, cyc);        /* JE^[Zbg */
  
  /*
   * ^C}[0Cl[uCI[g[hC_EJEg@݋@
   */
  sil_wrw_mem((VP)TIMER_TCSR0,TIMER_ENABLE | TIMER_RELOAD | TIMER_DOWN_COUNT
                                | TIMER_ENABLE_INTR);

  /*
   *  INTC݋
   */
  intc_enable_interrupt((1 << (TIMINTLVL - 1)));
}



/*
 *   ^C}ݗṽNA
 */
Inline void
hw_timer_int_clear()
{
  sil_wrw_mem((VP)TIMER_TCSR0,sil_rew_mem((VP)TIMER_TCSR0));
  /*
   * x݂̂߁Cݗv낵ACK
   */
  intc_ack_interrupt(1 << (TIMINTLVL - 1));
}



/*
 *   ^C}̋֎~
 */
Inline void
hw_timer_terminate()
{
  int dummy;
  
  sil_wrw_mem((VP)TIMER_TCSR0, ~TIMER_ENABLE); /* ^C}~         */
  sil_wrw_mem((VP)TIMER_TCSR0, sil_rew_mem((VP)TIMER_TCSR0));  /* ݗṽNA */
  
  /*
   * łɊ݂Ăꍇ̂ŊݗvNA
   */
  dummy = 1 << (TIMINTLVL - 1);
  intc_ack_interrupt(dummy);
  intc_disable_interrupt(dummy);  /* INTC̎󂯕t֎~ */
}



/*
 *   ^C}̌ݒl̓ǂݏo
 *
 *   ݋֎~ԒŌĂяo
 */
Inline CLOCK
hw_timer_get_current(void)
{
  return(TO_CLOCK(TIC_NUME, TIC_DENO) - sil_rew_mem((VP)TIMER_TCR0));
}



/*
 *   ݂Ă邩̔
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
  return(sil_rew_mem((VP)TIMER_TCSR0) & TIMER_INTERRUPT);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
