/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: hw_serial.h,v 1.1 2008/06/17 00:04:36 suikan Exp $
 */

/*
 *  VAI/OfoCXiSIOjhCoiMicroBlaze opb_uartpj
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#include <microblaze.h>


/*
 *  VAI/O̊݃nh̊ݔԍ
 */
#define INHNO_SIO UARTINTLVL


/*
 *  SIOhCȍ[`
 */
#define sio_initialize uart_initialize

#ifndef _MACRO_ONLY

/*
 *  VAI/O|[g̃I[v
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB  *siopcb;
    
    /*
     *  foCXˑ̃I[v
     */
    siopcb = uart_opn_por(siopid, exinf);

    /*
     * INTC̊݋
     */
    intc_enable_interrupt((1 << (UARTINTLVL - 1)));

    return(siopcb);
}


/*
 * VAI/O|[g̏I
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
  /*                                                                          
   *  foCXˑ̃N[YD                                            
   */
  uart_cls_por(siopcb);
  
  /*
   * łɊ݂Ăꍇ̂ŊݗvNA
   */
  intc_ack_interrupt(1 << (UARTINTLVL -1));
  intc_disable_interrupt(1 << (UARTINTLVL -1));  /* INTC̎󂯕t֎~ */
}


/*                                                                             
 *  SIO̊݃nh                                                        
 */
#define sio_handler uart_isr

/*                                                                             
 *  VAI/O|[gւ̕M                                              
 */
#define sio_snd_chr uart_snd_chr



/*
 *  VAI/O|[g̕M
 */
#define sio_rcv_chr uart_rcv_chr

/*
 *  VAI/O|[g̃R[obN̋
 */
#define sio_ena_cbr uart_ena_cbr

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
#define sio_dis_cbr uart_dis_cbr

/*
 *  VAI/O|[g̑M\R[obN
 */
#define sio_ierdy_snd   uart_ierdy_snd

/*
 *  VAI/O|[g̎MʒmR[obN
 */
#define sio_ierdy_rcv   uart_ierdy_rcv


#endif /* _MACRO_ONLY */
#endif /*  _HW_SERIAL_H_ */
