/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sys_config.c,v 1.1 2008/06/17 00:04:55 suikan Exp $
 */

/*
 *	^[QbgVXeˑW[iM3A-ZA36pj
 */
#include <sys_rename.h>
#include <s_services.h>

#include "jsp_kernel.h"
#include <hw_serial.h>

/*
 *  ^[QbgVXeˑ̏
 */
void
sys_initialize()
{
	/* UART */
	sil_wrb_mem((void *)(SIOCR(CONSOLE_PORTID-1)+3), 0);

	/* |[gJ(UART0) */
	sil_wrb_mem((void *)PDATA(5), 0);
	sil_wrb_mem((void *)PDIR(5),  0x80);

	/* UART, Non-parity, 1 stop-bit */
	sil_wrb_mem((void *)(SIOMOD0(CONSOLE_PORTID-1)+3), 0);

	/* 8bit, internal clock */
	sil_wrh_mem((void *)(SIOMOD1(CONSOLE_PORTID-1)+2), 0x0800);

	/* M32R(32102) - f(BLK)=10MHz57600bps */
	sil_wrh_mem((void *)(SIOBAUR(CONSOLE_PORTID-1)+2), SERIAL_CLKDIV);
	sil_wrb_mem((void *)(SIORBAUR(CONSOLE_PORTID-1)+3), SERIAL_CLKCMP);

	/* Xe[^XNA, MJn */
	sil_wrb_mem((void *)(SIOCR(CONSOLE_PORTID-1)+2), 0x3);
	sil_wrb_mem((void *)(SIOCR(CONSOLE_PORTID-1)+3), 0x3);

	/* TxD,RxDsL(UART0) */
	sil_wrh_mem((void *)PMOD(5), 0x5500);
}

/*
 *  ^[QbgVXȅI
 */
void
sys_exit(void)
{
	dis_int();
	*(volatile unsigned char *)(ICUIMASK+1) = 0;
	while(1==1)
	{
		/* d̓[hֈڍs */
		__asm(	"stb	%0, @%1	\n"
				"ldb	%0, @%1 \n"
			  	"nop\nnop\nnop\nnop\nnop\nnop\nnop\nnop"
			: : "r"(1), "r"(CLKMOD+3) );
	}
}

/*
 *  ^[QbgVXe̕o
 */
void
sys_putc(char c)
{
	if(c == '\n')
		sys_putc('\r');
	while( (sil_reb_mem((void *)(SIOSTS(CONSOLE_PORTID-1)+3)) & 0x1) == 0);	/* M҂ */
	sil_wrb_mem((void *)(SIOTXB(CONSOLE_PORTID-1)+3), c);	/* ꕶM */
}
